
#include "../include/defined_names.h"
#include "../include/file_path.h"
#include <oosxl.hxx>

#include <iostream>


using namespace oo;

void define_name()
{
    Document* doc = create_document();
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("defined_names");

    wb->add_worksheet("another sheet");

    // Define a global name
    bool b = wb->set_defined_name("global_name", "defined_names!$B$2:$C$3");
    if (!b)
        std::cout << run_msg() << std::endl;

    // Define a local name
    b = wb->set_defined_name("local_name", "'another names'!$B$2:$C$3", "another sheet");
    if (!b)
        std::cout << run_msg() << std::endl;

    // Define constant names
    b = wb->set_defined_name("pi", "3.1415926");
    if (!b)
        std::cout << run_msg() << std::endl;

    int size = wb->defined_mame_num();
    for (int i = 0; i < size; ++i)
    {
        bool is_local = false;
        const char* name = wb->get_defined_mame(i, &is_local);
        std::cout << name << "  ";
        if (is_local)
            std::cout << "local" << "  ";
        const char* expr = wb->get_defined_mame_expr(i);
        std::cout << expr << std::endl;
    }

    auto path = target_file("defined_names.xlsx");
    if (!doc->save(path.string().c_str()))
        std::cout << "Error saving file: " << run_msg() << std::endl;

    doc->release();
}

