
#include "../include/formula.h"
#include "../include/file_path.h"
#include <oosxl.hxx>

#include <iostream>


using namespace oo;

void formula()
{
    Document* doc = create_document();
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("formula");

    ws->set_num(3, 2, 1);
    ws->set_num(4, 2, 2);

    ws->set_formula(5, 2, "=B3+B4");

    // If you have already calculated the result of the formula,
    // you can set the value of the formula
    ws->set_formula_num(5, 2, 3);

    // Now, you can get some information about the formula
    bool b = ws->contains_formula(5, 2);
    std::cout << "Cell(5,2) " << (b ? "contains" : "does not contain") << " a formula." << std::endl;
    if (b)
    {
        const char* expr = ws->get_formula_expr(5, 2);
        std::cout << "The formula expression is " << expr << std::endl;

        // If the formula has a calculation result,
        // you can immediately query the value of the formula
        CellTypeEnum type = ws->cell_type(5, 2);
        if (type == CELLTYPE_NUMBER) {
            double value = ws->get_num(5, 2);
            std::cout << "The formula value is " << value << std::endl;
        }
    }

    auto path = target_file("formula.xlsx");
    if (!doc->save(path.string().c_str()))
        std::cout << "Error saving file: " << run_msg() << std::endl;

    doc->release();
}

