
#include "../include/defined_names.h"
#include "../include/file_path.h"
#include <oosxl.h>

#include <stdio.h>


void define_name()
{
    DocumentHandle doc = doc_create();
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "defined_names");

    wb_add_worksheet(wb, "another sheet");

    // Define a global name
    int b = wb_set_defined_name(wb, "global_name", "defined_names!$B$2:$C$3", NULL);
    if (!b)
        printf("%s\n", run_msg());

    // Define a local name
    b = wb_set_defined_name(wb, "local_name", "'another names'!$B$2:$C$3", "another sheet");
    if (!b)
        printf("%s\n", run_msg());

    // Define constant names
    b = wb_set_defined_name(wb, "pi", "3.1415926", NULL);
    if (!b)
        printf("%s\n", run_msg());

    int size = wb_defined_name_num(wb);
    for (int i = 0; i < size; ++i)
    {
        int is_local = 0;
        const char* name = wb_get_defined_name(wb, i, &is_local);
        printf("  ");
        if (is_local)
            printf("local  ");
        const char* expr = wb_get_defined_name_expr(wb, i);
        printf("%s\n", expr);
    }

    if (!doc_save(doc, target_file("defined_nameds.xlsx")))
        printf("Error saving file: %s\n", run_msg());

    doc_release(doc);
}

