
#include "../include/merge_cells.h"
#include "../include/file_path.h"
#include <oosxl.h>

#include <stdio.h>


void merge_cells()
{
    DocumentHandle doc = doc_create();
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "merge cells");

    // Merge cells (3, 3) - (20, 10)
    ws_merge(ws, 3, 3, 20, 10);

    // Get merged cell range
    int size = ws_merged_num(ws);
    for (int i = 0; i < size; ++i)
    {
        int row1 = 0, col1 = 0, row2 = 0, col2 = 0;
        ws_merged_range(ws, i, &row1, &col1, &row2, &col2);
    }

    // Unmerge cells
    //ws_unmerge(ws, 3, 3);

    if (!doc_save(doc, target_file("merge_cells.xlsx")))
        printf("Error saving file: %s\n", run_msg());

    doc_release(doc);
}
