
#include "../include/outline.h"
#include "../include/file_path.h"
#include <oosxl.h>

#include <stdio.h>


void outline()
{
    DocumentHandle doc = doc_create();
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "row outline");

    // Create an outline of rows
    ws_group_rows(ws, 1, 10, 0);
    ws_group_rows(ws, 1, 10, 0);
    ws_group_rows(ws, 1, 10, 0);
    ws_group_rows(ws, 20, 30, 0);
    ws_group_rows(ws, 5, 25, 0);
    ws_group_rows(ws, 7, 37, 0);
    ws_group_rows(ws, 20, 37, 0);

    // Ungroup rows
    ws_ungroup_rows(ws, 10, 22);
    ws_ungroup_rows(ws, 30, 37);

    // Ungroup all rows
    //ws->delete_row_outline();

    if (!doc_save(doc, target_file("outline.xlsx")))
        printf("Error saving file: %s\n", run_msg());

    doc_release(doc);
}

