
#include "../include/height_and_width.h"
#include "../include/file_path.h"
#include <oosxl.h>

#include <stdio.h>


void rich_text()
{
    DocumentHandle doc = doc_create();
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "rich text");
    
    RichtextHandle rt = wb_make_richtext(wb);

    StyleHandle fmt = wb_make_normal_style(wb);
    style_set_font(fmt, "Consolas", 18);
    style_set_font_color(fmt, 0x00FF00);
    rt_append(rt, "This is", fmt);

    rt_append(rt, " ", fmt);

    style_set_font_size(fmt, 12);
    style_set_font_color(fmt, 0xFF7F50);
    rt_append(rt, "a ", fmt);

    style_set_font(fmt, "Calibri", 28);
    style_set_bold(fmt, 1);
    style_set_italic(fmt, 1);
    style_set_font_color(fmt, 0xFF0000);
    rt_append(rt, "very interesting", fmt);

    style_set_font_size(fmt, 16);
    style_set_bold(fmt, 0);
    style_set_italic(fmt, 0);
    style_set_font_color(fmt, 0xD2691E);
    rt_append(rt, " thing.", fmt);

    ws_set_richtext(ws, 3, 3, rt);
    rt_release(rt);

    if (!doc_save(doc, target_file("rich text.xlsx")))
        printf("Error saving file: %s\n", run_msg());

    style_release(fmt);
    doc_release(doc);
}
