#ifndef OOSXL_MODULE_H
#define OOSXL_MODULE_H

// #define PY_SSIZE_T_CLEAN
#include <Python.h>

#include "object_types.h"


extern PyTypeObject DocumentType;
extern PyTypeObject WorkbookType;
extern PyTypeObject WorksheetType;
extern PyTypeObject StyleType;
extern PyTypeObject RichtextType;
extern PyTypeObject TabledefType;

// Function for creating python types
PyObject* create_document_object(DocumentHandle handle);
PyObject* create_workbook_object(WorkbookHandle handle);
PyObject* create_worksheet_object(WorksheetHandle handle);
PyObject* create_style_object(StyleHandle handle);
PyObject* create_richtext_object(RichtextHandle handle);
PyObject* create_tabledef_object(TabledefHandle handle);

// Utility functions
int check_handle(void* handle, const char* name);
// PyObject* create_enum_dict(void);

// Module initialization
PyMODINIT_FUNC PyInit__oosxl(void);

#endif // OOSXL_MODULE_H
