/**
 * worksheet.h (C interface header file)
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef WORKSHEET_INTERFACE_C_H
#define WORKSHEET_INTERFACE_C_H

#include "port.h"
#include "handle.h"


#ifdef __cplusplus
extern "C" {
#endif

    DYLIB_PORT              int  DYLIB_CALL ws_min_row(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_max_row(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_min_col(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_max_col(WorksheetHandle ws);

    DYLIB_PORT       const char* DYLIB_CALL ws_name(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_set_name(WorksheetHandle ws, const char* newname);
    DYLIB_PORT              int  DYLIB_CALL ws_ws_type(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_get_ws_state(WorksheetHandle ws);

    DYLIB_PORT              int  DYLIB_CALL ws_cell_type(WorksheetHandle ws, int row, int col);
    DYLIB_PORT              int  DYLIB_CALL ws_contains_formula(WorksheetHandle ws, int row, int col);
    DYLIB_PORT              int  DYLIB_CALL ws_contains_richtext(WorksheetHandle ws, int row, int col);
    DYLIB_PORT           double  DYLIB_CALL ws_get_num(WorksheetHandle ws, int row, int col);
    DYLIB_PORT       const char* DYLIB_CALL ws_get_text(WorksheetHandle ws, int row, int col);
    DYLIB_PORT              int  DYLIB_CALL ws_get_boolean(WorksheetHandle ws, int row, int col);
    DYLIB_PORT           double  DYLIB_CALL ws_get_datetime(WorksheetHandle ws, int row, int col);
    DYLIB_PORT   RichtextHandle  DYLIB_CALL ws_get_richtext(WorksheetHandle ws, int row, int col);
    DYLIB_PORT       const char* DYLIB_CALL ws_get_formula_expr(WorksheetHandle ws, int row, int col);
    DYLIB_PORT              int  DYLIB_CALL ws_get_error(WorksheetHandle ws, int row, int col);
    DYLIB_PORT              int  DYLIB_CALL ws_set_num(WorksheetHandle ws, int row, int col, double val);
    DYLIB_PORT              int  DYLIB_CALL ws_set_text(WorksheetHandle ws, int row, int col, const char* val);
    DYLIB_PORT              int  DYLIB_CALL ws_set_boolean(WorksheetHandle ws, int row, int col, int b);
    DYLIB_PORT              int  DYLIB_CALL ws_set_datetime(WorksheetHandle ws, int row, int col, double dt);
    DYLIB_PORT              int  DYLIB_CALL ws_set_richtext(WorksheetHandle ws, int row, int col, RichtextHandle rt);
    DYLIB_PORT              int  DYLIB_CALL ws_set_error(WorksheetHandle ws, int row, int col, int code);
    DYLIB_PORT              int  DYLIB_CALL ws_set_formula(WorksheetHandle ws, int row, int col, const char* expr);
    DYLIB_PORT              int  DYLIB_CALL ws_set_formula_num(WorksheetHandle ws, int row, int col, double val);
    DYLIB_PORT              int  DYLIB_CALL ws_set_formula_string(WorksheetHandle ws, int row, int col, const char* s);
    DYLIB_PORT              int  DYLIB_CALL ws_set_formula_boolean(WorksheetHandle ws, int row, int col, int b);
    DYLIB_PORT              int  DYLIB_CALL ws_set_formula_datetime(WorksheetHandle ws, int row, int col, double dt);
    DYLIB_PORT              int  DYLIB_CALL ws_set_formula_error(WorksheetHandle ws, int row, int col, int code);
    DYLIB_PORT             void  DYLIB_CALL ws_clear_contents(WorksheetHandle ws, int beginRow, int beginCol, int endRow, int endCol);

    DYLIB_PORT             void  DYLIB_CALL ws_set_cell_style(WorksheetHandle ws, int row, int col, StyleHandle style);
    DYLIB_PORT      StyleHandle  DYLIB_CALL ws_cell_style(WorksheetHandle ws, int row, int col);
    DYLIB_PORT      StyleHandle  DYLIB_CALL ws_get_cell_style(WorksheetHandle ws, int row, int col);
    DYLIB_PORT             void  DYLIB_CALL ws_set_range_style(WorksheetHandle ws, int startRow, int startCol, int stopRow, int stopCol, StyleHandle style);

    DYLIB_PORT              int  DYLIB_CALL ws_is_default_row_height(WorksheetHandle ws, int start, int end);
    DYLIB_PORT              int  DYLIB_CALL ws_get_custom_row_height(WorksheetHandle ws, int start, int end, double* height, int unit);
    DYLIB_PORT             void  DYLIB_CALL ws_set_custom_row_height(WorksheetHandle ws, int start, int end, double height, int unit);
    DYLIB_PORT              int  DYLIB_CALL ws_is_default_col_width(WorksheetHandle ws, int start, int end);
    DYLIB_PORT              int  DYLIB_CALL ws_get_custom_col_width(WorksheetHandle ws, int start, int end, double* width, int unit);
    DYLIB_PORT             void  DYLIB_CALL ws_set_custom_col_width(WorksheetHandle ws, int start, int end, double width, int unit);

    DYLIB_PORT      StyleHandle  DYLIB_CALL ws_row_style(WorksheetHandle ws, int row);
    DYLIB_PORT             void  DYLIB_CALL ws_remove_row_style(WorksheetHandle ws, int row);
    DYLIB_PORT             void  DYLIB_CALL ws_set_row_style(WorksheetHandle ws, int startRow, int stopRow, StyleHandle style);
    DYLIB_PORT      StyleHandle  DYLIB_CALL ws_col_style(WorksheetHandle ws, int col);
    DYLIB_PORT             void  DYLIB_CALL ws_remove_col_style(WorksheetHandle ws, int col);
    DYLIB_PORT             void  DYLIB_CALL ws_set_col_style(WorksheetHandle ws, int startCol, int stopCol, StyleHandle style);
    
    DYLIB_PORT              int  DYLIB_CALL ws_row_hidden(WorksheetHandle ws, int row);
    DYLIB_PORT             void  DYLIB_CALL ws_set_row_hidden(WorksheetHandle ws, int startRow, int stopRow, int hidden);
    DYLIB_PORT              int  DYLIB_CALL ws_col_hidden(WorksheetHandle ws, int col);
    DYLIB_PORT             void  DYLIB_CALL ws_set_col_hidden(WorksheetHandle ws, int startCol, int stopCol, int hidden);

    DYLIB_PORT              int  DYLIB_CALL ws_insert_row(WorksheetHandle ws, int row, int count);
    DYLIB_PORT              int  DYLIB_CALL ws_delete_row(WorksheetHandle ws, int begin, int end);
    DYLIB_PORT              int  DYLIB_CALL ws_insert_col(WorksheetHandle ws, int col, int count);
    DYLIB_PORT              int  DYLIB_CALL ws_delete_col(WorksheetHandle ws, int begin, int end);

    DYLIB_PORT              int  DYLIB_CALL ws_shift_range_down(WorksheetHandle ws, int startCol, int endCol, int startRow, int count);
    DYLIB_PORT              int  DYLIB_CALL ws_shift_range_up(WorksheetHandle ws, int startCol, int endCol, int startRow, int count);
    DYLIB_PORT              int  DYLIB_CALL ws_shift_range_right(WorksheetHandle ws, int startRow, int endRow, int startCol, int count);
    DYLIB_PORT              int  DYLIB_CALL ws_shift_range_left(WorksheetHandle ws, int startRow, int endRow, int startCol, int count);

    DYLIB_PORT             void  DYLIB_CALL ws_set_bg_picture(WorksheetHandle ws, const char* file);
    DYLIB_PORT              int  DYLIB_CALL ws_add_cell_image(WorksheetHandle ws, const char* file, int startRow, int startCol, int stopRow, int stopCol);
    DYLIB_PORT              int  DYLIB_CALL ws_add_image_with_two_cells(WorksheetHandle ws, const char* file, int row1, int col1, int row2, int col2,
                                                                        int offset_x1, int offset_y1, int offset_x2, int offset_y2);
    DYLIB_PORT              int  DYLIB_CALL ws_add_image_with_one_cell(WorksheetHandle ws, const char* file, int row, int col, int width, int height,
                                                                       double scale, int offset_x, int offset_y);
    DYLIB_PORT              int  DYLIB_CALL ws_add_absolute_image(WorksheetHandle ws, const char* file, int x, int y, int width, int height,double scale);
    DYLIB_PORT              int  DYLIB_CALL ws_image_num(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_get_image_id(WorksheetHandle ws, int index);
    DYLIB_PORT              int  DYLIB_CALL ws_image_anchor_type(WorksheetHandle ws, int image_id);
    DYLIB_PORT              int  DYLIB_CALL ws_get_anchored_cell(WorksheetHandle ws, int image_id, int* row, int* col);
    DYLIB_PORT              int  DYLIB_CALL ws_get_absolute_coord(WorksheetHandle ws, int image_id, int* x, int* y);
    DYLIB_PORT             void  DYLIB_CALL ws_delete_image(WorksheetHandle ws, int image_id);
    DYLIB_PORT             void  DYLIB_CALL ws_remove_image(WorksheetHandle ws, int row, int col);
    DYLIB_PORT             void  DYLIB_CALL ws_remove_absolute_image(WorksheetHandle ws, int x, int y);

    DYLIB_PORT              int  DYLIB_CALL ws_first_data_cell(WorksheetHandle ws, int* row, int* col);
    DYLIB_PORT              int  DYLIB_CALL ws_last_data_cell(WorksheetHandle ws, int* row, int* col);

    DYLIB_PORT              int  DYLIB_CALL ws_merged_num(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_merged_range(WorksheetHandle ws, int index, int* startRow, int* startCol, int* stopRow, int* stopCol);
    DYLIB_PORT              int  DYLIB_CALL ws_merge(WorksheetHandle ws, int startRow, int startCol, int stopRow, int stopCol);
    DYLIB_PORT              int  DYLIB_CALL ws_unmerge(WorksheetHandle ws, int row, int col);

    DYLIB_PORT              int  DYLIB_CALL ws_tabledef_count(WorksheetHandle ws);
    DYLIB_PORT       const char* DYLIB_CALL ws_get_tabledef_name(WorksheetHandle ws, int index);
    DYLIB_PORT              int  DYLIB_CALL ws_set_tabledef_name(WorksheetHandle ws, int index, const char* new_name);
    DYLIB_PORT   TabledefHandle  DYLIB_CALL ws_get_tabledef(WorksheetHandle ws, int index);
    DYLIB_PORT   TabledefHandle  DYLIB_CALL ws_get_tabledef_by_name(WorksheetHandle ws, const char* name);
    DYLIB_PORT   TabledefHandle  DYLIB_CALL ws_add_tabledef(WorksheetHandle ws, const char* name, int beginRow, int beginCol, int endRow, int endCol);
    DYLIB_PORT              int  DYLIB_CALL ws_delete_tabledef(WorksheetHandle ws, const char* name);

    DYLIB_PORT             void  DYLIB_CALL ws_group_rows(WorksheetHandle ws, int beginRow, int endRow, int collapsed);
    DYLIB_PORT             void  DYLIB_CALL ws_ungroup_rows(WorksheetHandle ws, int beginRow, int endRow);
    DYLIB_PORT             void  DYLIB_CALL ws_group_cols(WorksheetHandle ws, int beginCol, int endCol, int collapsed);
    DYLIB_PORT             void  DYLIB_CALL ws_ungroup_cols(WorksheetHandle ws, int beginCol, int endCol);
    DYLIB_PORT              int  DYLIB_CALL ws_row_outline_level(WorksheetHandle ws, int row, int* collapsed);
    DYLIB_PORT              int  DYLIB_CALL ws_col_outline_level(WorksheetHandle ws, int col, int* collapsed);
    DYLIB_PORT              int  DYLIB_CALL ws_max_row_outline_level(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_max_col_outline_level(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_delete_row_outline(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_delete_col_outline(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_group_summary_below(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_group_summary_below(WorksheetHandle ws, int below);
    DYLIB_PORT              int  DYLIB_CALL ws_group_summary_right(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_group_summary_right(WorksheetHandle ws, int right);

    DYLIB_PORT              int  DYLIB_CALL ws_add_hyperlink(WorksheetHandle ws, const char* hyperlink, int startRow, int startCol, int endRow, int endCol);
    DYLIB_PORT              int  DYLIB_CALL ws_hyperlink_num(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_hyperlink_index(WorksheetHandle ws, int row, int col);
    DYLIB_PORT       const char* DYLIB_CALL ws_hyperlink(WorksheetHandle ws, int index, int* startRow, int* startCol, int* endRow, int* endCol);
    DYLIB_PORT              int  DYLIB_CALL ws_delete_hyperlink(WorksheetHandle ws, int index);

    DYLIB_PORT              int  DYLIB_CALL ws_is_protected(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_protect(WorksheetHandle ws, int item, const char* password);
    DYLIB_PORT             void  DYLIB_CALL ws_unprotect(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_protect_range(WorksheetHandle ws, int startRow, int startCol, int endRow, int endCol);
    DYLIB_PORT              int  DYLIB_CALL ws_set_editable_range(WorksheetHandle ws, int startRow, int startCol, int endRow, int endCol);
    DYLIB_PORT              int  DYLIB_CALL ws_editable_range_count(WorksheetHandle ws);
    DYLIB_PORT       const char* DYLIB_CALL ws_get_editable_range(WorksheetHandle ws, int index, int* startRow, int* startCol, int* stopRow, int* stopCol);
    DYLIB_PORT              int  DYLIB_CALL ws_delete_editable_range(WorksheetHandle ws, int index);

    DYLIB_PORT              int  DYLIB_CALL ws_zoom(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_zoom(WorksheetHandle ws, int zoom);
    DYLIB_PORT              int  DYLIB_CALL ws_right_to_left(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_right_to_left(WorksheetHandle ws, int right_to_left);
    DYLIB_PORT             void  DYLIB_CALL ws_topleft_cell(WorksheetHandle ws, int* row, int* col);
    DYLIB_PORT             void  DYLIB_CALL ws_set_topleft_cell(WorksheetHandle ws, int row, int col);
    DYLIB_PORT             void  DYLIB_CALL ws_active_cell(WorksheetHandle ws, int* row, int* col);
    DYLIB_PORT             void  DYLIB_CALL ws_set_active_cell(WorksheetHandle ws, int row, int col);
    DYLIB_PORT             void  DYLIB_CALL ws_split_cell(WorksheetHandle ws, int* row, int* col);
    DYLIB_PORT             void  DYLIB_CALL ws_set_split_cell(WorksheetHandle ws, int row, int col);
    DYLIB_PORT              int  DYLIB_CALL ws_display_gridlines(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_display_gridlines(WorksheetHandle ws, int show);

    DYLIB_PORT              int  DYLIB_CALL ws_row_break_count(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_row_break(WorksheetHandle ws, int index);
    DYLIB_PORT              int  DYLIB_CALL ws_set_row_break(WorksheetHandle ws, int row, int pageBreak);
    DYLIB_PORT              int  DYLIB_CALL ws_col_break_count(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_col_break(WorksheetHandle ws, int index);
    DYLIB_PORT              int  DYLIB_CALL ws_set_col_break(WorksheetHandle ws, int col, int pageBreak);

    DYLIB_PORT              int  DYLIB_CALL ws_print_gridlines(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_print_gridlines(WorksheetHandle ws, int print);
    DYLIB_PORT              int  DYLIB_CALL ws_print_headings(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_print_headings(WorksheetHandle ws, int print);
    DYLIB_PORT              int  DYLIB_CALL ws_h_centered_printing(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_h_centered_printing(WorksheetHandle ws, int centered);
    DYLIB_PORT              int  DYLIB_CALL ws_v_centered_printing(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_v_centered_printing(WorksheetHandle ws, int centered);

    DYLIB_PORT           double  DYLIB_CALL ws_left_margin(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_left_margin(WorksheetHandle ws, double value);
    DYLIB_PORT           double  DYLIB_CALL ws_right_margin(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_right_margin(WorksheetHandle ws, double value);
    DYLIB_PORT           double  DYLIB_CALL ws_top_margin(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_top_margin(WorksheetHandle ws, double value);
    DYLIB_PORT           double  DYLIB_CALL ws_bottom_margin(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_bottom_margin(WorksheetHandle ws, double value);
    DYLIB_PORT           double  DYLIB_CALL ws_header_margin(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_header_margin(WorksheetHandle ws, double value);
    DYLIB_PORT           double  DYLIB_CALL ws_footer_margin(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_footer_margin(WorksheetHandle ws, double value);

    DYLIB_PORT              int  DYLIB_CALL ws_paper(WorksheetHandle ws);
    DYLIB_PORT              int  DYLIB_CALL ws_set_paper(WorksheetHandle ws, int paper_code);
    DYLIB_PORT              int  DYLIB_CALL ws_print_scale(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_print_scale(WorksheetHandle ws, int zoom);
    DYLIB_PORT              int  DYLIB_CALL ws_page_orientation(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_page_orientation(WorksheetHandle ws, int orientation);
    DYLIB_PORT              int  DYLIB_CALL ws_print_errors(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_print_errors(WorksheetHandle ws, int way);
    DYLIB_PORT              int  DYLIB_CALL ws_fit_page_height(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_fit_page_height(WorksheetHandle ws, int num);
    DYLIB_PORT              int  DYLIB_CALL ws_fit_page_width(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_fit_page_width(WorksheetHandle ws, int num);

    DYLIB_PORT       const char* DYLIB_CALL ws_page_header(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_page_header(WorksheetHandle ws, const char* header);
    DYLIB_PORT       const char* DYLIB_CALL ws_page_footer(WorksheetHandle ws);
    DYLIB_PORT             void  DYLIB_CALL ws_set_page_footer(WorksheetHandle ws, const char* footer);

#ifdef __cplusplus
};
#endif

#endif // WORKSHEET_INTERFACE_C_H

