
#include "../include/image.h"
#include "../include/file_path.h"
#include <oosxl.hxx>

#include <iostream>


using namespace oo;

void images()
{
    Document* doc = create_document();
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("absolute anchor");

    auto image_path = resource_path();
    image_path /= "example.jpeg";
    ws->add_absolute_image(image_path.string().c_str(), 0, 0);

    ws = wb->add_worksheet("one cell anchor");
    ws->add_image_with_one_cell(image_path.string().c_str(), 3, 3);

    ws = wb->add_worksheet("two cell anchor");
    int id = ws->add_image_with_two_cells(image_path.string().c_str(), 3, 3, 10, 10);

    //ws->delete_image(id);

    auto path = target_file("images.xlsx");
    if (!doc->save(path.string().c_str()))
        std::cout << "Error saving file: " << run_msg() << std::endl;

    doc->release();
}
