
#include "../include/merge_cells.h"
#include "../include/file_path.h"
#include <oosxl.hxx>

#include <iostream>


using namespace oo;

void merge_cells()
{
    Document* doc = create_document();
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("merge cells");

    // Merge cells (3, 3) - (20, 10)
    ws->merge(3, 3, 20, 10);

    // Get merged cell range
    int size = ws->merged_num();
    for (int i = 0; i < size; ++i)
    {
        int row1 = 0, col1 = 0, row2 = 0, col2 = 0;
        ws->merged_range(i, &row1, &col1, &row2, &col2);
        std::cout << "Merged range " << i << ": ("
            << row1 << "," << col1 << ") - ("
            << row2 << "," << col2 << ")" << std::endl;
    }

    // Unmerge cells
    //ws->unmerge(3, 3);

    auto path = target_file("merge_cells.xlsx");
    if (!doc->save(path.string().c_str()))
        std::cout << "Error saving file: " << run_msg() << std::endl;

    doc->release();
}
