
#include "../include/protect.h"
#include "../include/file_path.h"
#include <oosxl.hxx>

#include <iostream>


using namespace oo;

void protect()
{
    Document* doc = create_document();
    Workbook* wb = doc->get_workbook();

    // Protect sheet
    Worksheet* ws = wb->add_worksheet("protect sheet");
    ws->protect(PROTECT_DEFAULT, "123");
    //ws->unprotect();

    Style* style = wb->get_named_style("accent2");

    // Protect range
    ws = wb->add_worksheet("protect range");
    ws->set_range_style(3, 3, 10, 10, style);
    ws->protect_range(3, 3, 10, 10);

    // Set editable range
    ws = wb->add_worksheet("editable area");
    ws->set_range_style(3, 3, 10, 10, style);
    style = wb->get_named_style("accent6");
    ws->set_cell_style(7, 7, style);
    ws->set_cell_style(8, 8, style);
    ws->protect_range(3, 3, 10, 10);
    ws->set_editable_range(7, 7, 7, 7);
    ws->set_editable_range(8, 8, 8, 8);
    ws->set_editable_range(9, 9, 9, 9);
    ws->delete_editable_range(2);

    auto path = target_file("protect.xlsx");
    if (!doc->save(path.string().c_str()))
        std::cout << "Error saving file: " << run_msg() << std::endl;

    style->release();
    doc->release();
}
