
#include "../include/create_document.h"
#include "../include/open_document.h"
#include "../include/read_and_write_cells.h"
#include "../include/formula.h"
#include "../include/styles.h"
#include "../include/rich_text.h"
#include "../include/merge_cells.h"
#include "../include/defined_names.h"
#include "../include/outline.h"
#include "../include/image.h"
#include "../include/protect.h"
#include "../include/number_format.h"
#include "../include/height_and_width.h"
#include "../include/insert_and_delete.h"
#include "../include/table_definition.h"


int main()
{
    create_new_document();
    create_example_document();

    open_existing_document();

    write_cells();
    read_cells();

    formula();

    set_default_style();
    set_row_and_col_style();
    set_cell_style();
    set_range_style();
    
    rich_text();

    merge_cells();

    define_name();

    outline();

    images();

    protect();

    number_format();

    height_and_width();

    insert_and_delete();

    table_definition();

    return 0;
}

