
#include "../include/formula.h"
#include "../include/file_path.h"
#include <oosxl.h>

#include <stdio.h>


void formula()
{
    DocumentHandle doc = doc_create();
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "formula");

    ws_set_num(ws, 3, 2, 1);
    ws_set_num(ws, 4, 2, 2);

    ws_set_formula(ws, 5, 2, "=B3+B4");

    // If you have already calculated the result of the formula,
    // you can set the value of the formula
    ws_set_formula_num(ws, 5, 2, 3);

    // Now, you can get some information about the formula
    int b = ws_contains_formula(ws, 5, 2);
    if (b)
    {
        const char* expr = ws_get_formula_expr(ws, 5, 2);
        printf("The formula expression is %s\n", expr);

        // If the formula has a calculation result,
        // you can immediately query the value of the formula
        int type = ws_cell_type(ws, 5, 2);
        if (type == CELLTYPE_NUMBER) {
            double value = ws_get_num(ws, 5, 2);
            printf("The formula value is %f\n", value);
        }
    }

    if (!doc_save(doc, target_file("formula.xlsx")))
        printf("Error saving file: %s\n", run_msg());

    doc_release(doc);
}

