
#include "../include/image.h"
#include "../include/file_path.h"
#include <oosxl.h>

#include <stdio.h>


void images()
{
    DocumentHandle doc = doc_create();
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "absolute anchor");

    const char* image_path = resource_file("example.jpeg");
    ws_add_absolute_image(ws, image_path, 0, 0, 0, 0, 1);

    ws = wb_add_worksheet(wb, "one cell anchor");
    ws_add_image_with_one_cell(ws, image_path, 3, 3, 0, 0, 1, 0, 0);

    ws = wb_add_worksheet(wb, "two cell anchor");
    int id = ws_add_image_with_two_cells(ws, image_path, 3, 3, 10, 10, 0, 0, 0, 0);

    //ws->delete_image(id);

    const char* file = target_file("images.xlsx");
    if (!doc_save(doc, file))
        printf("Error saving file: %s\n", run_msg());

    doc_release(doc);
}
