
#include "../include/number_format.h"
#include "../include/file_path.h"
#include <oosxl.h>

#include <stdio.h>


void number_format()
{
    DocumentHandle doc = doc_create();
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "number format");

    // Set built-in number format
    ws_set_num(ws, 3, 3, 123.456);
    StyleHandle fmt = ws_cell_style(ws, 2, 3);
    style_set_numfmt_id(fmt, 14);
    ws_set_cell_style(ws, 3, 3, fmt);

    // Set custom number format
    ws_set_num(ws, 5, 3, 123.456);
    style_set_numfmt(fmt, "yyyy-mm-dd");
    ws_set_cell_style(ws, 5, 3, fmt);

    // Format numbers with ID
    ws_set_num(ws, 7, 3, 123.456);
    int numfmt_id = style_numfmt_id(fmt);
    StyleHandle style = wb_get_named_style(wb, "normal");
    style_set_numfmt_id(style, numfmt_id);
    ws_set_cell_style(ws, 7, 3, style);

    // Format numbers with code
    ws_set_num(ws, 9, 3, 123.456);
    fmt = ws_cell_style(ws, 9, 3);
    const char* numfmt_code = style_numfmt_code(style);
    style_set_numfmt(fmt, numfmt_code);
    ws_set_cell_style(ws, 9, 3, fmt);

    if (!doc_save(doc, target_file("number format.xlsx")))
        printf("Error saving file: %s\n", run_msg());

    doc_release(doc);
}