
#include "../include/protect.h"
#include "../include/file_path.h"
#include <oosxl.h>

#include <stdio.h>


void protect()
{
    DocumentHandle doc = doc_create();
    WorkbookHandle wb = doc_get_workbook(doc);

    // Protect sheet
    WorksheetHandle ws = wb_add_worksheet(wb, "protect sheet");
    ws_protect(ws, PROTECT_DEFAULT, "123");
    //ws->unprotect();

    StyleHandle style = wb_get_named_style(wb, "accent2");

    // Protect range
    ws = wb_add_worksheet(wb, "protect range");
    ws_set_range_style(ws, 3, 3, 10, 10, style);
    ws_protect_range(ws, 3, 3, 10, 10);

    // Set editable range
    ws = wb_add_worksheet(wb, "editable area");
    ws_set_range_style(ws, 3, 3, 10, 10, style);
    style = wb_get_named_style(wb, "accent6");
    ws_set_cell_style(ws, 7, 7, style);
    ws_set_cell_style(ws, 8, 8, style);
    ws_protect_range(ws, 3, 3, 10, 10);
    ws_set_editable_range(ws, 7, 7, 7, 7);
    ws_set_editable_range(ws, 8, 8, 8, 8);
    ws_set_editable_range(ws, 9, 9, 9, 9);
    ws_delete_editable_range(ws, 2);

    if (!doc_save(doc, target_file("protect.xlsx")))
        printf("Error saving file: %s\n", run_msg());

    style_release(style);
    doc_release(doc);
}
