
#include "../include/styles.h"
#include "../include/file_path.h"
#include <oosxl.h>

#include <stdio.h>


void set_default_style()
{
    DocumentHandle doc = doc_create();
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "default style");

    // Firstly, create a style that is closest to what you want
    StyleHandle style = wb_make_normal_style(wb);

    // Second, modify certain items to fully meet your expectations
    style_set_font(style, "Consolas", 12);
    style_set_border(style, BORDERINDEX_EDGE, BORDER_THIN);

    // Now, change the default style to your own style
    wb_modify_named_style(wb, "normal", style); 

    ws_set_text(ws, 7, 2, "Default style: Font(Consolas, size 12) | Border(outline border, thin)");

    // Save to style_settings.xlsx
    if (!doc_save(doc, target_file("style_settings.xlsx")))
        printf("Error saving file: %s\n", run_msg());

    // Don't forget to release "fmt" and "doc"
    style_release(style);
    doc_release(doc);
}

void set_row_and_col_style()
{
    DocumentHandle doc = doc_load(target_file("style_settings.xlsx"));
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "Set row and row style");

    // First, make a style
    StyleHandle style = wb_make_normal_style(wb);

    // Second, custome the style
    style_set_pattern_fg_color(style, 0x00FF00);
    style_set_fill_pattern(style, PATTERNTYPE_SOLID);

    // Apply the style to rows
    ws_set_text(ws, 6, 1, "We set the pattern color for row 7 and column 11 to green and the pattern style to 50% gray.");
    ws_set_row_style(ws, 7, 7, style);
    ws_set_col_style(ws, 11, 11, style);

    // Save to style_settings.xlsx
    if (!doc_save(doc, NULL))
        printf("Error saving file: %s\n", run_msg());

    // Don't forget to release "style" and "doc"
    style_release(style);
    doc_release(doc);
}

void set_cell_style()
{
    DocumentHandle doc = doc_load(target_file("style_settings.xlsx"));
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "Set cell style");

    int row = 3, col = 3;

    const char* text[] =
    {
        "Normal",
        "Comma",
        "Comma [0]",
        "Currency",
        "Currency [0]",
        "Percent",
        "Title",
        "Heading 1",
        "Heading 2",
        "Heading 3",
        "Heading 4",
        "Good",
        "Bad",
        "Neutral",
        "Input",
        "Output",
        "Calculation",
        "Linked Cell",
        "Check Cell",
        "Warning Text",
        "Note",
        "Explanatory Text",
        "Total",
        "Accent1",
        "20% - Accent1",
        "40% - Accent1",
        "60% - Accent1",
        "Accent2",
        "20% - Accent2",
        "40% - Accent2",
        "60% - Accent2",
        "Accent3",
        "20% - Accent3",
        "40% - Accent3",
        "60% - Accent3",
        "Accent4",
        "20% - Accent4",
        "40% - Accent4",
        "60% - Accent4",
        "Accent5",
        "20% - Accent5",
        "40% - Accent5",
        "60% - Accent5",
        "Accent6",
        "20% - Accent6",
        "40% - Accent6",
        "60% - Accent6"
    };

    for (int i = 0; i < sizeof(text) / sizeof(const char*); ++i)
    {
        ws_set_text(ws, row + i, col, text[i]);
    }

    ws_set_num(ws, row + 1, col, 123456.789);
    ws_set_num(ws, row + 2, col, 123456.789);
    ws_set_num(ws, row + 3, col, 123456.789);
    ws_set_num(ws, row + 4, col, 123456.789);
    ws_set_num(ws, row + 5, col, 123456.789);

    const char* builtin_cell_style_names[] =
    {
        "normal",
        "comma",
        "comma0",
        "currency",
        "currency0",
        "percent",
        "title",
        "heading1",
        "heading2",
        "heading3",
        "heading4",
        "good",
        "bad",
        "neutral",
        "input",
        "output",
        "calculation",
        "linkedCell",
        "checkCell",
        "warningText",
        "note",
        "explanatoryText",
        "total",
        "accent1",
        "accent1pct20",
        "accent1pct40",
        "accent1pct60",
        "accent2",
        "accent2pct20",
        "accent2pct40",
        "accent2pct60",
        "accent3",
        "accent3pct20",
        "accent3pct40",
        "accent3pct60",
        "accent4",
        "accent4pct20",
        "accent4pct40",
        "accent4pct60",
        "accent5",
        "accent5pct20",
        "accent5pct40",
        "accent5pct60",
        "accent6",
        "accent6pct20",
        "accent6pct40",
        "accent6pct60",
    };

    for (int i = 0; i < sizeof(builtin_cell_style_names) / sizeof(const char*); ++i)
    {
        StyleHandle style = wb_get_named_style(wb, builtin_cell_style_names[i]);
        ws_set_cell_style(ws, row + i, col, style);
        style_release(style);
    }

    ws_set_custom_col_width(ws, col, col, 30, COLWIDTH_CHARS);

    if (!doc_save(doc, NULL))
        printf("Error saving file: %s\n", run_msg());

    doc_release(doc);
}

void set_range_style()
{
    DocumentHandle doc = doc_load(target_file("style_settings.xlsx"));
    WorkbookHandle wb = doc_get_workbook(doc);
    WorksheetHandle ws = wb_add_worksheet(wb, "Set range style");

    StyleHandle style = wb_get_named_style(wb, "accent6pct20");

    style_set_border(style, BORDERINDEX_EDGE, BORDER_THICK);
    style_set_border(style, BORDERINDEX_INSIDE, BORDER_THIN);

    ws_set_range_style(ws, 3, 2, 8, 8, style);

    ws_set_text(ws, 10, 2, "Range is a single cell:");
    ws_set_range_style(ws, 11, 2, 11, 2, style);

    ws_set_text(ws, 13, 2, "Range of cells on a single row:");
    ws_set_range_style(ws, 14, 2, 14, 7, style);

    ws_set_text(ws, 16, 2, "Range of cells on a single column:");
    ws_set_range_style(ws, 17, 2, 22, 2, style);

    style_release(style);

    if (!doc_save(doc, NULL))
        printf("Error saving file: %s\n", run_msg());

    doc_release(doc);
}

