#include "oosxl_module.h"


#define INIT_TYPE(type) \
    if (PyType_Ready(&type) < 0) \
        return NULL;

#define ADD_INT_CONSTANT(v) PyModule_AddIntConstant(m, #v, v)


extern struct PyModuleDef oosxl_module;

PyMODINIT_FUNC PyInit__oosxl(void)
{
    PyObject* m;

    // Initialize all pythone types
    INIT_TYPE(DocumentType);
    INIT_TYPE(WorkbookType);
    INIT_TYPE(WorksheetType);
    INIT_TYPE(StyleType);
    INIT_TYPE(RichtextType);
    INIT_TYPE(TabledefType);

    m = PyModule_Create(&oosxl_module);
    if (m == NULL)
        return NULL;

    // Add DocumentType to the module
    Py_INCREF(&DocumentType);

    Py_INCREF(&WorkbookType);
    Py_INCREF(&WorksheetType);
    Py_INCREF(&StyleType);
    Py_INCREF(&RichtextType);
    Py_INCREF(&TabledefType);

    // Add enumeration constants
    ADD_INT_CONSTANT(CALCTYPE_AUTO);
    ADD_INT_CONSTANT(CALCTYPE_MANUAL);
    ADD_INT_CONSTANT(CALCTYPE_AUTONOTABLE);

    ADD_INT_CONSTANT(SHEETTYPE_UNKNOWN);
    ADD_INT_CONSTANT(SHEETTYPE_WORKSHEET);
    ADD_INT_CONSTANT(SHEETTYPE_CHARTSHEET);
    ADD_INT_CONSTANT(SHEETTYPE_DIALOGSHEET);

    ADD_INT_CONSTANT(SHEETSTATE_VISIBLE);
    ADD_INT_CONSTANT(SHEETSTATE_HIDDEN);
    ADD_INT_CONSTANT(SHEETSTATE_VERYHIDDEN);

    ADD_INT_CONSTANT(PROTECT_SELECT_LOCKED_CELLS);
    ADD_INT_CONSTANT(PROTECT_SELECT_UNLOCKED_CELLS);
    ADD_INT_CONSTANT(PROTECT_OBJECTS);
    ADD_INT_CONSTANT(PROTECT_SCENARIOS);
    ADD_INT_CONSTANT(PROTECT_FORMAT_CELLS);
    ADD_INT_CONSTANT(PROTECT_FORMAT_COLUMNS);
    ADD_INT_CONSTANT(PROTECT_FORMAT_ROWS);
    ADD_INT_CONSTANT(PROTECT_INSERT_COLUMNS);
    ADD_INT_CONSTANT(PROTECT_INSERT_ROWS);
    ADD_INT_CONSTANT(PROTECT_INSERT_HYPERLINKS);
    ADD_INT_CONSTANT(PROTECT_DELETE_COLUMNS);
    ADD_INT_CONSTANT(PROTECT_DELETE_ROWS);
    ADD_INT_CONSTANT(PROTECT_SORT);
    ADD_INT_CONSTANT(PROTECT_AUTOFILTER);
    ADD_INT_CONSTANT(PROTECT_PIVOTTABLES);
    ADD_INT_CONSTANT(PROTECT_ALL);
    ADD_INT_CONSTANT(PROTECT_DEFAULT);

    ADD_INT_CONSTANT(CELLTYPE_NONE);
    ADD_INT_CONSTANT(CELLTYPE_BLANK);
    ADD_INT_CONSTANT(CELLTYPE_NUMBER);
    ADD_INT_CONSTANT(CELLTYPE_STRING);
    ADD_INT_CONSTANT(CELLTYPE_BOOLEAN);
    ADD_INT_CONSTANT(CELLTYPE_DATETIME);
    ADD_INT_CONSTANT(CELLTYPE_ERROR);

    ADD_INT_CONSTANT(ERRCODE_UNKNOWN);
    ADD_INT_CONSTANT(ERRCODE_NONE);
    ADD_INT_CONSTANT(ERRCODE_NULL);
    ADD_INT_CONSTANT(ERRCODE_DIV_0);
    ADD_INT_CONSTANT(ERRCODE_VALUE);
    ADD_INT_CONSTANT(ERRCODE_REF);
    ADD_INT_CONSTANT(ERRCODE_NAME);
    ADD_INT_CONSTANT(ERRCODE_NUM);
    ADD_INT_CONSTANT(ERRCODE_NA);
    ADD_INT_CONSTANT(ERRCODE_GETTING_DATA);
    ADD_INT_CONSTANT(ERRCODE_SPILL);

    ADD_INT_CONSTANT(HALIGN_GENERAL);
    ADD_INT_CONSTANT(HALIGN_LEFT);
    ADD_INT_CONSTANT(HALIGN_CENTER);
    ADD_INT_CONSTANT(HALIGN_RIGHT);
    ADD_INT_CONSTANT(HALIGN_FILL);
    ADD_INT_CONSTANT(HALIGN_JUSTIFY);
    ADD_INT_CONSTANT(HALIGN_CENTERCONTINUOUS);
    ADD_INT_CONSTANT(HALIGN_DISTRIBUTED);

    ADD_INT_CONSTANT(VALIGN_BOTTOM);
    ADD_INT_CONSTANT(VALIGN_CENTER);
    ADD_INT_CONSTANT(VALIGN_TOP);
    ADD_INT_CONSTANT(VALIGN_JUSTIFY);
    ADD_INT_CONSTANT(VALIGN_DISTRIBUTED);

    ADD_INT_CONSTANT(BORDER_NONE);
    ADD_INT_CONSTANT(BORDER_THIN);
    ADD_INT_CONSTANT(BORDER_MEDIUM);
    ADD_INT_CONSTANT(BORDER_THICK);
    ADD_INT_CONSTANT(BORDER_DOUBLE);
    ADD_INT_CONSTANT(BORDER_DASHED);
    ADD_INT_CONSTANT(BORDER_MEDIUMDASHED);
    ADD_INT_CONSTANT(BORDER_DASHDOT);
    ADD_INT_CONSTANT(BORDER_MEDIUMDASHDOT);
    ADD_INT_CONSTANT(BORDER_DASHDOTDOT);
    ADD_INT_CONSTANT(BORDER_MEDIUMDASHDOTDOT);
    ADD_INT_CONSTANT(BORDER_SLANTDASHDOT);
    ADD_INT_CONSTANT(BORDER_DOTTED);
    ADD_INT_CONSTANT(BORDER_HAIR);

    ADD_INT_CONSTANT(BORDERINDEX_LEFT);
    ADD_INT_CONSTANT(BORDERINDEX_RIGHT);
    ADD_INT_CONSTANT(BORDERINDEX_TOP);
    ADD_INT_CONSTANT(BORDERINDEX_BOTTOM);
    ADD_INT_CONSTANT(BORDERINDEX_HORIZONTAL);
    ADD_INT_CONSTANT(BORDERINDEX_VERTICAL);
    ADD_INT_CONSTANT(BORDERINDEX_DIAGONAL_DOWN);
    ADD_INT_CONSTANT(BORDERINDEX_DIAGONAL_UP);

    ADD_INT_CONSTANT(BORDERINDEX_EDGE);
    ADD_INT_CONSTANT(BORDERINDEX_INSIDE);

    ADD_INT_CONSTANT(PATTERNTYPE_NONE);
    ADD_INT_CONSTANT(PATTERNTYPE_SOLID);
    ADD_INT_CONSTANT(PATTERNTYPE_DARKGRAY);
    ADD_INT_CONSTANT(PATTERNTYPE_MEDIUMGRAY);
    ADD_INT_CONSTANT(PATTERNTYPE_LIGHTGRAY);
    ADD_INT_CONSTANT(PATTERNTYPE_GRAY125);
    ADD_INT_CONSTANT(PATTERNTYPE_GRAY0625);
    ADD_INT_CONSTANT(PATTERNTYPE_DARKHORIZONTAL);
    ADD_INT_CONSTANT(PATTERNTYPE_DARKVERTICAL);
    ADD_INT_CONSTANT(PATTERNTYPE_DARKUP);
    ADD_INT_CONSTANT(PATTERNTYPE_DARKDOWN);
    ADD_INT_CONSTANT(PATTERNTYPE_DARKTRELLIS);
    ADD_INT_CONSTANT(PATTERNTYPE_DARKGRID);
    ADD_INT_CONSTANT(PATTERNTYPE_LIGHTHORIZONTAL);
    ADD_INT_CONSTANT(PATTERNTYPE_LIGHTVERTICAL);
    ADD_INT_CONSTANT(PATTERNTYPE_LIGHTUP);
    ADD_INT_CONSTANT(PATTERNTYPE_LIGHTDOWN);
    ADD_INT_CONSTANT(PATTERNTYPE_LIGHTTRELLIS);
    ADD_INT_CONSTANT(PATTERNTYPE_LIGHTGRID);

    ADD_INT_CONSTANT(VALIGNRUN_BASELINE);
    ADD_INT_CONSTANT(VALIGNRUN_SUBSCRIPT);
    ADD_INT_CONSTANT(VALIGNRUN_SUPERSCRIPT);

    ADD_INT_CONSTANT(UNDERLINE_NONE);
    ADD_INT_CONSTANT(UNDERLINE_SINGLE);
    ADD_INT_CONSTANT(UNDERLINE_SINGLEACCOUNTING);
    ADD_INT_CONSTANT(UNDERLINE_DOUBLE);
    ADD_INT_CONSTANT(UNDERLINE_DOUBLEACCOUNTING);

    ADD_INT_CONSTANT(TOTALS_FUNC_NONE);
    ADD_INT_CONSTANT(TOTALS_FUNC_SUM);
    ADD_INT_CONSTANT(TOTALS_FUNC_AVERAGE);
    ADD_INT_CONSTANT(TOTALS_FUNC_COUNT);
    ADD_INT_CONSTANT(TOTALS_FUNC_COUNT_NUMS);
    ADD_INT_CONSTANT(TOTALS_FUNC_CUSTOM);
    ADD_INT_CONSTANT(TOTALS_FUNC_MIN);
    ADD_INT_CONSTANT(TOTALS_FUNC_MAX);
    ADD_INT_CONSTANT(TOTALS_FUNC_STDDEV);
    ADD_INT_CONSTANT(TOTALS_FUNC_VAR);

    ADD_INT_CONSTANT(ROWHEIGHT_POINTS);
    ADD_INT_CONSTANT(ROWHEIGHT_INCH);
    ADD_INT_CONSTANT(ROWHEIGHT_MM);

    ADD_INT_CONSTANT(COLWIDTH_CHARS);
    ADD_INT_CONSTANT(COLWIDTH_INCH);
    ADD_INT_CONSTANT(COLWIDTH_MM);

    ADD_INT_CONSTANT(IMAGE_NOT_EXIST);
    ADD_INT_CONSTANT(IMAGE_ABSOLUTE);
    ADD_INT_CONSTANT(IMAGE_WITH_ONE_CELL);
    ADD_INT_CONSTANT(IMAGE_WITH_TWO_CELL);

    ADD_INT_CONSTANT(PAGEORIENT_DEFAULT);
    ADD_INT_CONSTANT(PAGEORIENT_LANDSCAPE);
    ADD_INT_CONSTANT(PAGEORIENT_PORTRAIT);

    ADD_INT_CONSTANT(PRINTORDER_DOWNTHENOVER);
    ADD_INT_CONSTANT(PRINTORDER_OVERTHENDOWN);

    ADD_INT_CONSTANT(PAPERUNIT_mm);
    ADD_INT_CONSTANT(PAPERUNIT_cm);
    ADD_INT_CONSTANT(PAPERUNIT_in);
    ADD_INT_CONSTANT(PAPERUNIT_pt);
    ADD_INT_CONSTANT(PAPERUNIT_pc);
    ADD_INT_CONSTANT(PAPERUNIT_pi);

    ADD_INT_CONSTANT(PRINTCMT_NONE);
    ADD_INT_CONSTANT(PRINTCMT_ASDISPLAYED);
    ADD_INT_CONSTANT(PRINTCMT_ATEND);

    ADD_INT_CONSTANT(PRINTERROR_BLANK);
    ADD_INT_CONSTANT(PRINTERROR_DASH);
    ADD_INT_CONSTANT(PRINTERROR_DISPLAYED);
    ADD_INT_CONSTANT(PRINTERROR_NA);

    return m;
}
