// swift-tools-version: 6.2.3

import Foundation
import PackageDescription

let package = Package(
    name: "swift_oosxl",
    platforms: [.macOS(.v12)],
    products: [
        .library(
            name: "swift_oosxl",
            type: .dynamic,
            targets: ["swift_oosxl"])
    ],
    targets: [
        .target(
            name: "cxx_oosxl",
            dependencies: [],
            path: ".",
            //exclude: ["liboosxl.dylib"],
            sources: ["c_module/dummy.c"],
            publicHeadersPath: "oosxl/include/c",
            cxxSettings: [
                .headerSearchPath("oosxl/include/c")
            ],
            linkerSettings: [
                .linkedLibrary("oosxl"),
                .unsafeFlags(["-L", "oosxl/lib/universal"]),
            ]
        ),
        .target(
            name: "swift_oosxl",
            dependencies: ["cxx_oosxl"],
            path: "swift_oosxl",
            swiftSettings: []
        ),
        .testTarget(
            name: "swift_oosxl_tests",
            dependencies: ["swift_oosxl"],
            linkerSettings: [
                .unsafeFlags([
                    "-Xlinker", "-rpath",
                    "-Xlinker", "@loader_path/../../../../../../oosxl/lib/universal",
                ]),
                .linkedLibrary("oosxl"),
            ]
        ),
    ]
)
