import Foundation
import Testing

@testable import swift_oosxl

@Suite(.serialized)
struct IntegrationTests {
    @Test func testCompleteWorkflow() throws {
        print("🚀 Start complete workflow testing...")

        // Create document
        let document = try #require(oosxl.createDocument())
        let workbook = document.workbook()

        // Add worksheet
        let worksheet = try #require(workbook.addSheet(sheetname: "Sales Report"))

        // Create test data
        let salesData: [[Any]] = [
            ["Product", "Q1", "Q2", "Q3", "Q4", "Total"],
            ["Product A", 10000, 15000, 12000, 18000],
            ["Product B", 8000, 12000, 9000, 14000],
            ["Product C", 15000, 18000, 16000, 22000],
            ["Average", "1", "", "", ""],
        ]

        // Populate data
        for (rowIndex, rowData) in salesData.enumerated() {
            for (colIndex, value) in rowData.enumerated() {
                #expect(worksheet.set(value, (rowIndex + 2, colIndex + 2)))
            }
        }

        // Add formula
        #expect(worksheet.setFormula("=SUM(C3:F3)", to: (3, 7)))  // Total Product A
        #expect(worksheet.setFormula("=SUM(C4:F4)", to: (4, 7)))  // Total Product B
        #expect(worksheet.setFormula("=SUM(C5:F5)", to: (5, 7)))  // Total Product C
        #expect(worksheet.setFormula("=AVERAGE(C3:C5)", to: (6, 3)))  // Q1 average

        // Apply style
        if let headerStyle = workbook.getNamedStyle("Normal") {
            headerStyle.font.bold = true
            headerStyle.font.size = 12
            worksheet.setRangeStyle(range: (2, 2, 2, 7), style: headerStyle)
        }

        // Set column width
        worksheet.setCustomColWidth(start: 2, end: 7, width: 12.0)

        // Verify data
        #expect(worksheet.getNumber(at: (3, 3)) == 10000.0)
        #expect(worksheet.getString(at: (2, 2)) == "Product")

        // Save document
        let sourceFile = #file
        let sourceDir = URL(fileURLWithPath: sourceFile).deletingLastPathComponent()
        let outputURL = sourceDir.appendingPathComponent("complete_workflow_test.xlsx")
        try document.save(to: outputURL.path)

        // Verify file creation
        #expect(FileManager.default.fileExists(atPath: outputURL.path))

        print("✅ Workflow testing completed, save file to: \(outputURL.path)")
    }
}
