/**
 * document.h (C interface header file)
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef DOCUMENT_INTERFACE_C_H
#define DOCUMENT_INTERFACE_C_H

#include "port.h"
#include "handle.h"


#ifdef __cplusplus
extern "C" {
#endif

DYLIB_PORT     const char* DYLIB_CALL get_version();
DYLIB_PORT DocumentHandle  DYLIB_CALL doc_create();
DYLIB_PORT DocumentHandle  DYLIB_CALL doc_load(const char* filename);
DYLIB_PORT           void  DYLIB_CALL set_key(DocumentHandle doc, const char* username, const char* key);
DYLIB_PORT WorkbookHandle  DYLIB_CALL doc_get_workbook(DocumentHandle doc);
DYLIB_PORT            int  DYLIB_CALL doc_save(DocumentHandle doc, const char* filename);
DYLIB_PORT           void  DYLIB_CALL doc_release(DocumentHandle doc);

#ifdef __cplusplus
}
#endif

#endif // DOCUMENT_INTERFACE_C_H

