/**
 * port.h
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef DYLIB_PORT_H
#define DYLIB_PORT_H


#if !defined(BUILDING_STATIC_LIBRARY) && defined(_WIN32)
    #if defined(_WIN64) || defined(__x86_64__) || defined(__aarch64__)
        #define DYLIB_CALL
    #elif defined(DYLIB_USE_STDCALL)
        #define DYLIB_CALL __stdcall
    #else
        #define DYLIB_CALL __cdecl
    #endif
#else
    #define DYLIB_CALL
#endif

#if !defined(BUILDING_STATIC_LIBRARY)
    #if defined(_MSC_VER)
        #ifdef DYLIB_EXPORTS
            #define DYLIB_PORT __declspec(dllexport)
        #else
            #define DYLIB_PORT __declspec(dllimport)
        #endif
    #elif defined(DYLIB_EXPORTS) && (defined(__GNUC__) || defined(__clang__))
        #define DYLIB_PORT __attribute__((visibility("default")))
    #else
        #define DYLIB_PORT
    #endif
#else
    #define DYLIB_PORT
#endif

#define DYLIB_API DYLIB_PORT DYLIB_CALL


#endif // DYLIB_PORT_H

