/**
 * rich_text.h (C interface header file)
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef RICH_TEXT_INTERFACE_C_H
#define RICH_TEXT_INTERFACE_C_H

#include "port.h"
#include "handle.h"


#ifdef __cplusplus
extern "C" {
#endif

    DYLIB_PORT        int  DYLIB_CALL rt_segments_num(RichtextHandle rt);
    DYLIB_PORT const char* DYLIB_CALL rt_plain_text(RichtextHandle rt);
    DYLIB_PORT const char* DYLIB_CALL rt_text(RichtextHandle rt, int index, StyleHandle* style);
    DYLIB_PORT       void  DYLIB_CALL rt_append(RichtextHandle rt, const char* s, StyleHandle style);
    DYLIB_PORT       void  DYLIB_CALL rt_insert(RichtextHandle rt, int index, const char* s, StyleHandle style);
    DYLIB_PORT       void  DYLIB_CALL rt_remove(RichtextHandle rt, int index);
    DYLIB_PORT       void  DYLIB_CALL rt_modify(RichtextHandle rt, int index, const char* s, StyleHandle style);

    DYLIB_PORT       void  DYLIB_CALL rt_release(RichtextHandle rt);

#ifdef __cplusplus
}
#endif

#endif // RICH_TEXT_INTERFACE_C_H

