/**
 * workbook.hxx
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef WORKBOOK_INTERFACE_H
#define WORKBOOK_INTERFACE_H

#include "port.h"
#include "enum.h"


namespace oo {

typedef void(*UndoAwarenessFunc)(bool, bool);

struct iWorksheet;
struct iStyle;
struct iRichtext;

struct iWorkbook
{
    virtual           bool  is_date1904() const = 0;
    virtual           void  set_date1904(bool set = true) = 0;
    virtual           bool  is_a1_ref_mode() const = 0;
    virtual           void  set_a1_ref_mode(bool a1_mode = true) = 0;
    virtual   CalcTypeEnum  get_calc_mode() const = 0;
    virtual           void  set_calc_mode(CalcTypeEnum type) = 0;

    virtual     iWorksheet* add_worksheet(const char* name = 0) = 0;
    virtual     iWorksheet* insert_worksheet(int index, const char* name = 0) = 0;
    virtual           void  shift_sheet(int srcIdx, int dstIdx) = 0;
    virtual           void  delete_sheet(int index) = 0;

    virtual            int  sheet_count() const = 0;
    virtual     iWorksheet* get_sheet(int index) const = 0;
    virtual  SheetTypeEnum  sheet_type(int index) const = 0;
    virtual SheetStateEnum  get_sheet_state(int index) const = 0;
    virtual           void  set_sheet_state(int index, SheetStateEnum state = SHEETSTATE_HIDDEN) = 0;

    virtual     const char* sheet_name(int index) const = 0;
    virtual           void  rename_sheet(int index, const char* newname) = 0;

    virtual            int  get_active_sheet() const = 0;
    virtual           bool  set_active_sheet(int tab) = 0;

    virtual            bool  set_defined_name(const char* name, const char* expr, const char* table_name = 0) = 0;
    virtual             int  defined_mame_num() const = 0;
    virtual      const char* get_defined_mame(int index, bool* is_local = 0) const = 0;
    virtual      const char* get_local_mame(int index) const = 0;
    virtual      const char* get_defined_mame_expr(int index) const = 0;
    virtual            void  delete_defined_name(int index) = 0;

    virtual         iStyle* get_named_style(const char* name) = 0;
    virtual         iStyle* add_custom_style(const char* name, iStyle* style) = 0;
    virtual           bool  modify_named_style(const char* name, iStyle* style) = 0;

    virtual         iStyle* make_normal_style() = 0;
    virtual      iRichtext* make_richtext() = 0;

protected:
    virtual  ~iWorkbook() { }
};

}

#endif // WORKBOOK_INTERFACE_H

