//
//  Tabledef.swift
//  oosxl
//

import cxx_oosxl

public enum TotalsFunction: Int32 {
    case none = 0
    case sum = 1
    case average = 2
    case count = 3
    case countNumbers = 4
    case custom = 5
    case min = 6
    case max = 7
    case standardDeviation = 8
    case variance = 9
}

public class Tabledef {
    let handle: TabledefHandle
    unowned let worksheet: Worksheet

    init(withHandle handle: TabledefHandle, worksheet: Worksheet) {
        self.handle = handle
        self.worksheet = worksheet
    }

    deinit {
    }

    public var name: String {
        guard let name = td_name(handle) else {
            return ""
        }

        return String(cString: name)
    }

    public var range: (Int, Int, Int, Int) {
        var row1: Int32 = 0
        var col1: Int32 = 0
        var row2: Int32 = 0
        var col2: Int32 = 0

        td_range(handle, &row1, &col1, &row2, &col2)
        return (Int(row1), Int(col1), Int(row2), Int(col2))
    }

    public var displayName: String {
        guard let name = td_display_name(handle) else {
            return ""
        }

        return String(cString: name)
    }

    public var comment: String {
        guard let content = td_comment(handle) else {
            return ""
        }

        return String(cString: content)
    }

    public func getColumnName(at index: Int) -> String? {
        guard let name = td_col_name(handle, Int32(index)) else {
            return nil
        }

        return String(cString: name)
    }

    public func setColumnName(at index: Int, name: String) -> Bool {
        let result = name.withCString { cString in
            return td_set_col_name(handle, Int32(index), cString)
        }
        return result != 0
    }

    public func insertColumn(at index: Int, name: String) -> Bool {
        let result = name.withCString { ptr in
            return td_insert_col(handle, Int32(index), ptr)
        }
        guard result != 0 else { return false }
        return true
    }

    public func deleteColumn(at index: Int) {
        td_delete_col_by_index(handle, Int32(index))
    }

    public func deleteColumn(name: String) {
        name.withCString { ptr in
            td_delete_col(handle, ptr)
        }
    }

    public func setTotalRowLabel(_ lable: String) {
        lable.withCString { ptr in
            td_set_totals_row_label(handle, ptr)
        }
    }

    public func totalsRowFunction(column col: Int) -> TotalsFunction {
        return TotalsFunction(rawValue: td_totals_row_func(handle, Int32(col)))!
    }

    public func setTotalsRowFunction(column: Int, function: TotalsFunction) {
        td_set_totals_row_func(handle, Int32(column), function.rawValue)
    }

    public func setPresetStyle(id: Int) {
        td_set_preset_style(handle, Int32(id))
    }

    public var style: String {
        get {
            let name = td_style_name(handle)
            return String(cString: name!)
        }
        set {
            newValue.withCString { ptr in
                td_set_style_name(handle, ptr)
            }
        }
    }

    public var rowStrips: Bool {
        get {
            return td_row_strips(handle) != 0
        }
        set {
            td_set_row_strips(handle, newValue ? 1 : 0)
        }
    }
}
