/**
 * tabledef.h (C interface header file)
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef TABLE_DEFINITION_INTERFACE_C_H
#define TABLE_DEFINITION_INTERFACE_C_H

#include "port.h"
#include "handle.h"


#ifdef __cplusplus
extern "C" {
#endif

    DYLIB_PORT const char* DYLIB_CALL td_name(TabledefHandle tl);
    DYLIB_PORT       void  DYLIB_CALL td_range(TabledefHandle tl, int* beginRow, int* beginCol, int* endRow, int* endCol);
    DYLIB_PORT const char* DYLIB_CALL td_display_name(TabledefHandle tl);
    DYLIB_PORT       void  DYLIB_CALL td_set_display_name(TabledefHandle tl, const char* name);
    DYLIB_PORT const char* DYLIB_CALL td_comment(TabledefHandle tl);
    DYLIB_PORT       void  DYLIB_CALL td_set_comment(TabledefHandle tl, const char* comment);
    DYLIB_PORT const char* DYLIB_CALL td_col_name(TabledefHandle tl, int idx);
    DYLIB_PORT        int  DYLIB_CALL td_set_col_name(TabledefHandle tl, int idx, const char* name);
    DYLIB_PORT        int  DYLIB_CALL td_insert_col(TabledefHandle tl, int idx, const char* colName);
    DYLIB_PORT       void  DYLIB_CALL td_delete_col_by_index(TabledefHandle tl, int idx);
    DYLIB_PORT       void  DYLIB_CALL td_delete_col(TabledefHandle tl, const char* colName);
    DYLIB_PORT       void  DYLIB_CALL td_set_totals_row_label(TabledefHandle tl, const char* label);
    DYLIB_PORT       void  DYLIB_CALL td_set_display_total(TabledefHandle tl, int show);
    DYLIB_PORT        int  DYLIB_CALL td_totals_row_func(TabledefHandle tl, int column_idx);
    DYLIB_PORT       void  DYLIB_CALL td_set_totals_row_func(TabledefHandle tl, int colIndex, int func);
    DYLIB_PORT const char* DYLIB_CALL td_style_name(TabledefHandle tl);
    DYLIB_PORT       void  DYLIB_CALL td_set_style_name(TabledefHandle tl, const char* style_name);
    DYLIB_PORT       void  DYLIB_CALL td_set_preset_style(TabledefHandle tl, int id);
    DYLIB_PORT        int  DYLIB_CALL td_row_strips(TabledefHandle tl);
    DYLIB_PORT       void  DYLIB_CALL td_set_row_strips(TabledefHandle tl, int strips);

#ifdef __cplusplus
};
#endif

#endif // TABLE_DEFINITION_INTERFACE_C_H

