/**
 * C headers
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef C_UTILITIES_H
#define C_UTILITIES_H

#include "port.h"

#include <wchar.h>


#ifdef __cplusplus
extern "C" {
#endif

DYLIB_PORT const char* DYLIB_CALL run_msg();
DYLIB_PORT        int  DYLIB_CALL to_ansi_string(const char* utf8_string, char* sp);
DYLIB_PORT        int  DYLIB_CALL to_wide_string(const char* utf8_string, wchar_t* wsp);
DYLIB_PORT        int  DYLIB_CALL a1_to_row_col(const char* s, int* row, int* col);
DYLIB_PORT        int  DYLIB_CALL wide_a1_to_row_col(const wchar_t* ws, int* row, int* col);
DYLIB_PORT        int  DYLIB_CALL row_col_to_a1(int row, int col, char* sp);
DYLIB_PORT       void  DYLIB_CALL decode_rgb(long rgb, int* red, int* green, int* blue);
DYLIB_PORT       long  DYLIB_CALL encode_rgb(int red, int green, int blue);
DYLIB_PORT       void  DYLIB_CALL decode_argb(long rgb, int* red, int* green, int* blue, int* alpha);
DYLIB_PORT       long  DYLIB_CALL encode_argb(int red, int green, int blue, int alpha);
DYLIB_PORT       void  DYLIB_CALL decode_date(double date, int* year, int* month, int* day);
DYLIB_PORT       void  DYLIB_CALL decode_date1904(double date, int* year, int* month, int* day);
DYLIB_PORT       void  DYLIB_CALL decode_time(double time, int* hour, int* minute, int* second, int* msec);
DYLIB_PORT       void  DYLIB_CALL decode_datetime(double datetime, int* year, int* month, int* day, int* hour, int* minute, int* second, int* msec);
DYLIB_PORT       void  DYLIB_CALL decode_datetime1904(double datetime, int* year, int* month, int* day, int* hour, int* minute, int* second, int* msec);
DYLIB_PORT     double  DYLIB_CALL encode_date(int year, int month, int day);
DYLIB_PORT     double  DYLIB_CALL encode_date1904(int year, int month, int day);
DYLIB_PORT     double  DYLIB_CALL encode_time(int hour, int minute, int second, int msec);
DYLIB_PORT     double  DYLIB_CALL encode_datetime(int year, int month, int day,  int hour, int minute, int second, int msec);
DYLIB_PORT     double  DYLIB_CALL encode_datetime1904(int year, int month, int day,  int hour, int minute, int second, int msec);

#ifdef __cplusplus
}
#endif

#endif // C_UTILITIES_H

