/**
 * tabledef.hxx
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef TABLE_DEFINITION_INTERFACE_H
#define TABLE_DEFINITION_INTERFACE_H

#include "port.h"
#include "enum.h"


namespace oo {

struct iTabledef
{
    virtual     const char* name() const = 0;
    virtual           void  range(int* beginRow, int* beginCol, int* endRow, int* endCol) const = 0;
    virtual     const char* display_name() const = 0;
    virtual           void  set_display_name(const char* name) = 0;
    virtual     const char* comment() const = 0;
    virtual           void  set_comment(const char* comment) = 0;
    virtual     const char* col_name(int idx) const = 0;
    virtual           bool  set_col_name(int idx, const char* name) = 0;
    virtual           bool  insert_col(int idx, const char* colName) = 0;
    virtual           void  delete_col_by_index(int idx) = 0;
    virtual           void  delete_col(const char* colName) = 0;
    virtual           void  set_totals_row_label(const char* label) = 0;
    virtual           void  set_display_total(bool show = true) = 0;
    virtual TotalsFuncEnum  totals_row_func(int column_idx) const = 0;
    virtual           void  set_totals_row_func(int colIndex, TotalsFuncEnum func) = 0;
    virtual     const char* style_name() const = 0;
    virtual           void  set_style_name(const char* style_name) = 0;
    virtual           void  set_preset_style(int id) = 0;
    virtual           bool  row_strips() const = 0;
    virtual           void  set_row_strips(bool strips = true) = 0;

protected:
    virtual ~iTabledef() {}
};

}

#endif //TABLE_DEFINITION_INTERFACE_H

