
# oosxlConfig.cmake.in
# Configuration file for the oosxl library


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was oosxlConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Check CMake version
if ("${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION}" LESS 2.5)
  message(FATAL_ERROR "CMake >= 2.6.0 required")
endif()
cmake_policy(PUSH)
cmake_policy(VERSION 2.6)

# Create imported target
add_library(oosxl::oosxl SHARED IMPORTED)

# Set interface include directories (point to the 'include' folder)
set_target_properties(oosxl::oosxl PROPERTIES
  INTERFACE_INCLUDE_DIRECTORIES
    "${CMAKE_CURRENT_LIST_DIR}/include/cxx;${CMAKE_CURRENT_LIST_DIR}/include/c"
)

# -------------------------------------------------------------------
# Platform-specific library path selection
# -------------------------------------------------------------------

# Helper to unset temporary variables at the end
set(_temp_vars)

# Windows
if (WIN32)
  # Determine architecture (x86, x64, arm64)
  if (CMAKE_SIZEOF_VOID_P EQUAL 8)
    if (CMAKE_SYSTEM_PROCESSOR MATCHES "ARM64")
      set(OOSXL_PLATFORM_SUBDIR "arm64")
    else()
      set(OOSXL_PLATFORM_SUBDIR "x64")
    endif()
  else()
    set(OOSXL_PLATFORM_SUBDIR "x86")
  endif()
  list(APPEND _temp_vars OOSXL_PLATFORM_SUBDIR)

  set(OOSXL_LIB_PATH "${CMAKE_CURRENT_LIST_DIR}/lib/${OOSXL_PLATFORM_SUBDIR}/oosxl.lib")
  set(OOSXL_DLL_PATH "${CMAKE_CURRENT_LIST_DIR}/lib/${OOSXL_PLATFORM_SUBDIR}/oosxl.dll")

  # Set properties (use same DLL for all configurations)
  set_target_properties(oosxl::oosxl PROPERTIES
    #IMPORTED_IMPLIB "${OOSXL_LIB_PATH}"
    #IMPORTED_LOCATION "${OOSXL_DLL_PATH}"
    IMPORTED_CONFIGURATIONS "DEBUG;RELEASE;RELWITHDEBINFO"
    IMPORTED_LOCATION_DEBUG ${OOSXL_DLL_PATH}
    IMPORTED_IMPLIB_DEBUG ${OOSXL_LIB_PATH}
    IMPORTED_LOCATION_RELEASE ${OOSXL_DLL_PATH}
    IMPORTED_IMPLIB_RELEASE ${OOSXL_LIB_PATH}
    IMPORTED_LOCATION_RELWITHDEBINFO ${OOSXL_DLL_PATH}
    IMPORTED_IMPLIB_RELWITHDEBINFO ${OOSXL_LIB_PATH}
  )
  #list(APPEND _temp_vars OOSXL_LIB_PATH OOSXL_DLL_PATH)
  list(APPEND _temp_vars OOSXL_LIB_PATH)

# Linux
elseif (UNIX AND NOT APPLE AND NOT CMAKE_SYSTEM_NAME STREQUAL "iOS")
  # Detect architecture
  set(OOSXL_PLATFORM_SUBDIR "")
  if (CMAKE_SYSTEM_PROCESSOR MATCHES "x86_64|amd64")
    set(OOSXL_PLATFORM_SUBDIR "x86_64")
  elseif (CMAKE_SYSTEM_PROCESSOR MATCHES "i386|i686|x86")
    set(OOSXL_PLATFORM_SUBDIR "i386")
  elseif (CMAKE_SYSTEM_PROCESSOR MATCHES "aarch64|arm64")
    set(OOSXL_PLATFORM_SUBDIR "aarch64")
  elseif (CMAKE_SYSTEM_PROCESSOR MATCHES "arm|armv7")
    set(OOSXL_PLATFORM_SUBDIR "armhf")
  else()
    message(FATAL_ERROR "Unsupported Linux architecture: ${CMAKE_SYSTEM_PROCESSOR}")
  endif()
  list(APPEND _temp_vars OOSXL_PLATFORM_SUBDIR)

  set(OOSXL_LIB_PATH "${CMAKE_CURRENT_LIST_DIR}/lib/${OOSXL_PLATFORM_SUBDIR}/liboosxl.so")
  set_target_properties(oosxl::oosxl PROPERTIES
    IMPORTED_LOCATION "${OOSXL_LIB_PATH}"
    IMPORTED_SONAME "liboosxl.so"
  )
  list(APPEND _temp_vars OOSXL_LIB_PATH)

# macOS (Darwin) but not iOS
elseif (APPLE AND NOT CMAKE_SYSTEM_NAME STREQUAL "iOS")
  # macOS: check for universal binary, else select based on architecture
  if (EXISTS "${CMAKE_CURRENT_LIST_DIR}/lib/universal/liboosxl.dylib")
    set(OOSXL_LIB_PATH "${CMAKE_CURRENT_LIST_DIR}/lib/universal/liboosxl.dylib")
  else()
    # Determine architecture
    set(OOSXL_PLATFORM_SUBDIR "")
    # Check CMAKE_OSX_ARCHITECTURES first (for multi-arch builds)
    if (CMAKE_OSX_ARCHITECTURES MATCHES "arm64" AND NOT CMAKE_OSX_ARCHITECTURES MATCHES "x86_64")
      set(OOSXL_PLATFORM_SUBDIR "arm64")
    elseif (CMAKE_OSX_ARCHITECTURES MATCHES "x86_64" AND NOT CMAKE_OSX_ARCHITECTURES MATCHES "arm64")
      set(OOSXL_PLATFORM_SUBDIR "x86_64")
    else()
      # Fallback to running uname -m (not recommended for cross-compilation)
      execute_process(COMMAND uname -m OUTPUT_VARIABLE OOSXL_ARCH OUTPUT_STRIP_TRAILING_WHITESPACE)
      if (OOSXL_ARCH MATCHES "arm64")
        set(OOSXL_PLATFORM_SUBDIR "arm64")
      elseif (OOSXL_ARCH MATCHES "x86_64")
        set(OOSXL_PLATFORM_SUBDIR "x86_64")
      else()
        message(FATAL_ERROR "Could not determine macOS architecture")
      endif()
      unset(OOSXL_ARCH)
    endif()
    list(APPEND _temp_vars OOSXL_PLATFORM_SUBDIR)
    set(OOSXL_LIB_PATH "${CMAKE_CURRENT_LIST_DIR}/lib/${OOSXL_PLATFORM_SUBDIR}/liboosxl.dylib")
  endif()

  set_target_properties(oosxl::oosxl PROPERTIES
    IMPORTED_LOCATION "${OOSXL_LIB_PATH}"
    IMPORTED_SONAME "@rpath/liboosxl.dylib"
  )
  list(APPEND _temp_vars OOSXL_LIB_PATH)

# iOS
#[[
elseif (CMAKE_SYSTEM_NAME STREQUAL "iOS")
  # iOS: determine target (device, simulator, catalyst)
  set(OOSXL_PLATFORM_SUBDIR "")
  # Check for modern CMake variables
  if (IOS_PLATFORM STREQUAL "OS" OR IOS_PLATFORM STREQUAL "DEVICE")
    set(OOSXL_PLATFORM_SUBDIR "arm64")
  elseif (IOS_PLATFORM STREQUAL "SIMULATOR" OR IOS_PLATFORM STREQUAL "SIMULATOR64")
    set(OOSXL_PLATFORM_SUBDIR "simulator")
  elseif (IOS_PLATFORM STREQUAL "MAC" OR PLATFORM_NAME STREQUAL "macosx")
    set(OOSXL_PLATFORM_SUBDIR "catalyst")
  else()
    # Fallback: use CMAKE_OSX_SYSROOT or architecture
    if (CMAKE_OSX_SYSROOT MATCHES "iphoneos")
      set(OOSXL_PLATFORM_SUBDIR "arm64")
    elseif (CMAKE_OSX_SYSROOT MATCHES "iphonesimulator")
      set(OOSXL_PLATFORM_SUBDIR "simulator")
    elseif (CMAKE_OSX_SYSROOT MATCHES "macosx")
      set(OOSXL_PLATFORM_SUBDIR "catalyst")
    else()
      message(FATAL_ERROR "Could not determine iOS target platform")
    endif()
  endif()
  list(APPEND _temp_vars OOSXL_PLATFORM_SUBDIR)

  set(OOSXL_LIB_PATH "${CMAKE_CURRENT_LIST_DIR}/lib/${OOSXL_PLATFORM_SUBDIR}/liboosxl.dylib")
  set_target_properties(oosxl::oosxl PROPERTIES
    IMPORTED_LOCATION "${OOSXL_LIB_PATH}"
    IMPORTED_SONAME "@rpath/liboosxl.dylib"
  )
  list(APPEND _temp_vars OOSXL_LIB_PATH)
]]

else()
  message(FATAL_ERROR "Unsupported platform: ${CMAKE_SYSTEM_NAME}")
endif()

# Clean up temporary variables
foreach(_var ${_temp_vars})
  unset(${_var})
endforeach()
unset(_temp_vars)

cmake_policy(POP)

