
#include "../include/create_document.h"
#include "../include/file_path.h"
#include <oosxl.hxx>

#include <iostream>
#include <vector>


using namespace oo;

bool create_new_document()
{
    Document* doc = create_document();
    Workbook* wb = doc->get_workbook();

    wb->add_worksheet();

    auto path = target_file("blank.xlsx");
    if (!doc->save(path.string().c_str()))
    {
        std::cout << run_msg() << std::endl;
        return false;
    }

    doc->release();
    return true;
}

void create_example_document()
{
    // Step 1: create a empty document
    Document* doc = create_document();
    if (!doc)
    {
        std::cout << "Error creating document: " << run_msg() << std::endl;
        return;
    }

    // Step 2: There is only one unique workbook in a document
    Workbook* wb = doc->get_workbook();

    // Step 3: At least one worksheet must be added to a empty document
    Worksheet* ws = wb->add_worksheet();

    // Now, let's start adding data to the worksheet

    int row = 3, col = 3;

    // Set titles
    std::vector<std::string> titles = { "Item", "Units", "Unit Cost", "Total" };
    for (int i = 0; i < static_cast<int>(titles.size()); ++i)
        ws->set_text(row, row + i, titles[i].c_str());

    // Set the first column
    std::vector<std::string> column1 = { "Baby doll", "Kite", "Toy guitar" };
    for (int i = 0; i < 3; ++i)
        ws->set_text(row + i, col, column1[i].c_str());

    // Set the second column
    std::vector<int> column2 = { 95, 60, 75 };
    for (int i = 0; i < 3; ++i)
        ws->set_num(row + i, col + 1, column2[i]);

    // Set the third column
    std::vector<double> column3 = { 1.99, 2.99, 6.99 };
    for (int i = 0; i < 3; ++i)
        ws->set_num(row + i, col + 2, column3[i]);

    // Set the fourth column
    ws->set_formula(row, col + 3, "=D3*E3");
    ws->set_formula(row + 1, col + 3, "=D4*E4");
    ws->set_formula(row + 2, col + 3, "=D5*E5");

    // Merge cell(6,2) - cell(6,4)
    ws->merge(row + 3, col, row + 3, col + 2);
    ws->set_text(row + 3, col, "Total");

    // Set total
    ws->set_formula(row + 3, col + 3, "=SUM(F3:F5)");

    // Set style
    Style* fmt = wb->get_named_style("normal");
    fmt->set_border(BORDERINDEX_EDGE, BORDER_THICK);
    fmt->set_border(BORDERINDEX_INSIDE, BORDER_THIN);
    ws->set_range_style(row, col, row + 3, col + 3, fmt);
    fmt->release();

    // Save to example.xlsx
    auto path = target_file("example.xlsx");
    if (!doc->save(path.string().c_str()))
        std::cout << "Error saving file: " << run_msg() << std::endl;

    doc->release();
}

