
#include "../include/number_format.h"
#include "../include/file_path.h"
#include <oosxl.hxx>

#include <iostream>


using namespace oo;

void number_format()
{
    Document* doc = create_document();
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("number format");

    // Set built-in number format
    ws->set_num(3, 3, 123.456);
    Style* fmt = ws->cell_style(2, 3);
    fmt->set_numfmt_id(14);
    ws->set_cell_style(3, 3, fmt);

    // Set custom number format
    ws->set_num(5, 3, 123.456);
    fmt->set_numfmt_code("yyyy-mm-dd");
    ws->set_cell_style(5, 3, fmt);

    // Format numbers with ID
    ws->set_num(7, 3, 123.456);
    int numfmt_id = fmt->numfmt_id();
    Style* style = wb->get_named_style("normal");
    style->set_numfmt_id(numfmt_id);
    ws->set_cell_style(7, 3, style);

    // Format numbers with code
    ws->set_num(9, 3, 123.456);
    fmt = ws->cell_style(9, 3);
    const char* numfmt_code = style->numfmt_code();
    fmt->set_numfmt_code(numfmt_code);
    ws->set_cell_style(9, 3, fmt);

    auto path = target_file("number format.xlsx");
    if (!doc->save(path.string().c_str()))
        std::cout << "Error saving file: " << run_msg() << std::endl;

    doc->release();
}