
#include "../include/height_and_width.h"
#include "../include/file_path.h"
#include <oosxl.hxx>

#include <iostream>


using namespace oo;

void rich_text()
{
    Document* doc = create_document();
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("rich text");
    
    Richtext* rt = wb->make_richtext();

    Style* fmt = wb->make_normal_style();
    fmt->set_font("Consolas", 18);
    fmt->set_font_color(0x00FF00);
    rt->append("This is", fmt);

    rt->append(" ", fmt);

    fmt->set_font_size(12);
    fmt->set_font_color(0xFF7F50);
    rt->append("a ", fmt);

    fmt->set_font("Calibri", 28);
    fmt->set_bold();
    fmt->set_italic();
    fmt->set_font_color(0xFF0000);
    rt->append("very interesting", fmt);

    fmt->set_font_size(16);
    fmt->set_bold(false);
    fmt->set_italic(false);
    fmt->set_font_color(0xD2691E);
    rt->append(" thing.", fmt);

    ws->set_richtext(3, 3, rt);
    rt->release();

    auto path = target_file("rich text.xlsx");
    if (!doc->save(path.string().c_str()))
        std::cout << "Error saving file: " << run_msg() << std::endl;

    fmt->release();
    doc->release();
}
