
#include "../include/styles.h"
#include "../include/file_path.h"
#include <oosxl.hxx>

#include <iostream>
#include <vector>


using namespace oo;

void set_default_style()
{
    Document* doc = create_document();
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("default style");

    // Firstly, create a style that is closest to what you want
    Style* style = wb->make_normal_style();

    // Second, modify certain items to fully meet your expectations
    style->set_font("Consolas", 12);
    style->set_border(BorderIndexEnum::BORDERINDEX_EDGE, BorderStyleEnum::BORDER_THIN);

    // Now, change the default style to your own style
    wb->modify_named_style("normal", style); 

    ws->set_text(7, 2, "Default style: Font(Consolas, size 12) | Border(outline border, thin)");

    // Save to style_settings.xlsx
    auto path = target_file("style_settings.xlsx");
    if (!doc->save(path.string().c_str()))
        std::cout << "Error saving file: " << run_msg() << std::endl;

    // Don't forget to release "fmt" and "doc"
    style->release();
    doc->release();
}

void set_row_and_col_style()
{
    auto path = target_file("style_settings.xlsx");
    Document* doc = load_document(path.string().c_str());
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("Set row and row style");

    // First, make a style
    Style* style = wb->make_normal_style();

    // Second, custome the style
    style->set_pattern_fg_color(0x00FF00);
    style->set_fill_pattern(PATTERNTYPE_SOLID);

    // Apply the style to rows
    ws->set_text(6, 1, "We set the pattern color for row 7 and column 11 to green and the pattern style to 50% gray.");
    ws->set_row_style(7, 7, style);
    ws->set_col_style(11, 11, style);

    // Save to style_settings.xlsx
    if (!doc->save())
        std::cout << "Error saving file: " << run_msg() << std::endl;

    // Don't forget to release "style" and "doc"
    style->release();
    doc->release();
}

void set_cell_style()
{
    auto path = target_file("style_settings.xlsx");
    Document* doc = load_document(path.string().c_str());
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("Set cell style");

    int row = 3, col = 3;

    std::vector<std::string> text =
    {
        "Normal",
        "Comma",
        "Comma [0]",
        "Currency",
        "Currency [0]",
        "Percent",
        "Title",
        "Heading 1",
        "Heading 2",
        "Heading 3",
        "Heading 4",
        "Good",
        "Bad",
        "Neutral",
        "Input",
        "Output",
        "Calculation",
        "Linked Cell",
        "Check Cell",
        "Warning Text",
        "Note",
        "Explanatory Text",
        "Total",
        "Accent1",
        "20% - Accent1",
        "40% - Accent1",
        "60% - Accent1",
        "Accent2",
        "20% - Accent2",
        "40% - Accent2",
        "60% - Accent2",
        "Accent3",
        "20% - Accent3",
        "40% - Accent3",
        "60% - Accent3",
        "Accent4",
        "20% - Accent4",
        "40% - Accent4",
        "60% - Accent4",
        "Accent5",
        "20% - Accent5",
        "40% - Accent5",
        "60% - Accent5",
        "Accent6",
        "20% - Accent6",
        "40% - Accent6",
        "60% - Accent6"
    };

    for (int i = 0; i < static_cast<int>(text.size()); ++i)
    {
        ws->set_text(row + i, col, text[i].c_str());
    }

    ws->set_num(row + 1, col, 123456.789);
    ws->set_num(row + 2, col, 123456.789);
    ws->set_num(row + 3, col, 123456.789);
    ws->set_num(row + 4, col, 123456.789);
    ws->set_num(row + 5, col, 123456.789);

    std::vector<std::string> builtin_cell_style_names =
    {
        "normal",
        "comma",
        "comma0",
        "currency",
        "currency0",
        "percent",
        "title",
        "heading1",
        "heading2",
        "heading3",
        "heading4",
        "good",
        "bad",
        "neutral",
        "input",
        "output",
        "calculation",
        "linkedCell",
        "checkCell",
        "warningText",
        "note",
        "explanatoryText",
        "total",
        "accent1",
        "accent1pct20",
        "accent1pct40",
        "accent1pct60",
        "accent2",
        "accent2pct20",
        "accent2pct40",
        "accent2pct60",
        "accent3",
        "accent3pct20",
        "accent3pct40",
        "accent3pct60",
        "accent4",
        "accent4pct20",
        "accent4pct40",
        "accent4pct60",
        "accent5",
        "accent5pct20",
        "accent5pct40",
        "accent5pct60",
        "accent6",
        "accent6pct20",
        "accent6pct40",
        "accent6pct60",
    };

    for (int i = 0; i < static_cast<int>(builtin_cell_style_names.size()); ++i)
    {
        Style* style = wb->get_named_style(builtin_cell_style_names[i].c_str());
        ws->set_cell_style(row + i, col, style);
        style->release();
    }

    ws->set_custom_col_width(col, col, 30);

    if (!doc->save())
        std::cout << "Error saving file: " << run_msg() << std::endl;

    doc->release();
}

void set_range_style()
{
    auto path = target_file("style_settings.xlsx");
    Document* doc = load_document(path.string().c_str());
    Workbook* wb = doc->get_workbook();
    Worksheet* ws = wb->add_worksheet("Set range style");

    Style* style = wb->get_named_style("accent6pct20");

    style->set_border(BORDERINDEX_EDGE, BORDER_THICK);
    style->set_border(BORDERINDEX_INSIDE, BORDER_THIN);

    ws->set_range_style(3, 2, 8, 8, style);

    ws->set_text(10, 2, "Range is a single cell:");
    ws->set_range_style(11, 2, 11, 2, style);

    ws->set_text(13, 2, "Range of cells on a single row:");
    ws->set_range_style(14, 2, 14, 7, style);

    ws->set_text(16, 2, "Range of cells on a single column:");
    ws->set_range_style(17, 2, 22, 2, style);

    style->release();

    if (!doc->save())
        std::cout << "Error saving file: " << run_msg() << std::endl;

    doc->release();
}

