#include "oosxl_module.h"


PyTypeObject StyleType;

static void Style_dealloc(StyleObject* self)
{
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject* Style_set_numfmt(StyleObject* self, PyObject* args)
{
    const char* numFmtCode;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "s", &numFmtCode))
    {
        return NULL;
    }

    int result = style_set_numfmt(self->handle, numFmtCode);
    if (result == 0)
    {
        PyErr_SetString(PyExc_RuntimeError, "Failed to set number format");
        return NULL;
    }

    Py_RETURN_NONE;
}

static PyObject* Style_numfmt_code(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    const char* result = style_numfmt_code(self->handle);
    if (result == NULL)
    {
        Py_RETURN_NONE;
    }

    return PyUnicode_FromString(result);
}

static PyObject* Style_numfmt_id(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_numfmt_id(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_numfmt_id(StyleObject* self, PyObject* args)
{
    int numFmtId;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &numFmtId))
    {
        return NULL;
    }

    int result = style_set_numfmt_id(self->handle, numFmtId);
    if (result == 0)
    {
        PyErr_SetString(PyExc_RuntimeError, "Failed to set number format ID");
        return NULL;
    }

    Py_RETURN_NONE;
}

static PyObject* Style_set_font(StyleObject* self, PyObject* args)
{
    const char* name;
    int size;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "si", &name, &size))
    {
        return NULL;
    }

    style_set_font(self->handle, name, size);
    Py_RETURN_NONE;
}

static PyObject* Style_font_name(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    const char* result = style_font_name(self->handle);
    if (result == NULL)
    {
        Py_RETURN_NONE;
    }

    return PyUnicode_FromString(result);
}

static PyObject* Style_font_size(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_font_size(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_font_size(StyleObject* self, PyObject* args)
{
    int size;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &size))
    {
        return NULL;
    }

    style_set_font_size(self->handle, size);
    Py_RETURN_NONE;
}

static PyObject* Style_italic(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_italic(self->handle);
    return PyBool_FromLong(result);
}

static PyObject* Style_set_italic(StyleObject* self, PyObject* args)
{
    int italic;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "p", &italic))
    {
        return NULL;
    }

    style_set_italic(self->handle, italic);
    Py_RETURN_NONE;
}

static PyObject* Style_strikeout(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_strikeout(self->handle);
    return PyBool_FromLong(result);
}

static PyObject* Style_set_strikeout(StyleObject* self, PyObject* args)
{
    int strikeOut;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "p", &strikeOut))
    {
        return NULL;
    }

    style_set_strikeout(self->handle, strikeOut);
    Py_RETURN_NONE;
}

static PyObject* Style_font_color(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    COLORREF result = style_font_color(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_font_color(StyleObject* self, PyObject* args)
{
    long color;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "l", &color))
    {
        return NULL;
    }

    style_set_font_color(self->handle, (COLORREF)color);
    Py_RETURN_NONE;
}

static PyObject* Style_bold(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_bold(self->handle);
    return PyBool_FromLong(result);
}

static PyObject* Style_set_bold(StyleObject* self, PyObject* args)
{
    int bold;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "p", &bold))
    {
        return NULL;
    }

    style_set_bold(self->handle, bold);
    Py_RETURN_NONE;
}

static PyObject* Style_font_vert_align(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_font_vert_align(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_font_vert_align(StyleObject* self, PyObject* args)
{
    int v_alignRun;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &v_alignRun))
    {
        return NULL;
    }

    style_set_font_vert_align(self->handle, v_alignRun);
    Py_RETURN_NONE;
}

static PyObject* Style_underlined(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_underlined(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_underline(StyleObject* self, PyObject* args)
{
    int underline;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &underline))
    {
        return NULL;
    }

    style_set_underline(self->handle, underline);
    Py_RETURN_NONE;
}

static PyObject* Style_border(StyleObject* self, PyObject* args)
{
    int index;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &index))
    {
        return NULL;
    }

    int result = style_border(self->handle, index);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_border(StyleObject* self, PyObject* args)
{
    int index, bs;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "ii", &index, &bs))
    {
        return NULL;
    }

    int result = style_set_border(self->handle, index, bs);
    if (result == 0)
    {
        PyErr_SetString(PyExc_RuntimeError, "Failed to set border");
        return NULL;
    }

    Py_RETURN_NONE;
}

static PyObject* Style_border_color(StyleObject* self, PyObject* args)
{
    int index;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &index))
    {
        return NULL;
    }

    COLORREF result = style_border_color(self->handle, index);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_border_color(StyleObject* self, PyObject* args)
{
    int index;
    long color;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "il", &index, &color))
    {
        return NULL;
    }

    int result = style_set_border_color(self->handle, index, (COLORREF)color);
    if (result == 0)
    {
        PyErr_SetString(PyExc_RuntimeError, "Failed to set border color");
        return NULL;
    }

    Py_RETURN_NONE;
}

static PyObject* Style_fill_pattern(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_fill_pattern(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_fill_pattern(StyleObject* self, PyObject* args)
{
    int pattern;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &pattern))
    {
        return NULL;
    }

    style_set_fill_pattern(self->handle, pattern);
    Py_RETURN_NONE;
}

static PyObject* Style_pattern_fg_color(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    COLORREF result = style_pattern_fg_color(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_pattern_fg_color(StyleObject* self, PyObject* args)
{
    long color;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "l", &color))
    {
        return NULL;
    }

    style_set_pattern_fg_color(self->handle, (COLORREF)color);
    Py_RETURN_NONE;
}

static PyObject* Style_pattern_bg_color(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    COLORREF result = style_pattern_bg_color(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_pattern_bg_color(StyleObject* self, PyObject* args)
{
    long color;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "l", &color))
    {
        return NULL;
    }

    style_set_pattern_bg_color(self->handle, (COLORREF)color);
    Py_RETURN_NONE;
}

static PyObject* Style_align_h(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_align_h(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_align_h(StyleObject* self, PyObject* args)
{
    int h_alignment;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &h_alignment))
    {
        return NULL;
    }

    style_set_align_h(self->handle, h_alignment);
    Py_RETURN_NONE;
}

static PyObject* Style_align_v(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_align_v(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_align_v(StyleObject* self, PyObject* args)
{
    int v_alignment;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &v_alignment))
    {
        return NULL;
    }

    style_set_align_v(self->handle, v_alignment);
    Py_RETURN_NONE;
}

static PyObject* Style_wrap(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_wrap(self->handle);
    return PyBool_FromLong(result);
}

static PyObject* Style_set_wrap(StyleObject* self, PyObject* args)
{
    int wrap;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "p", &wrap))
    {
        return NULL;
    }

    style_set_wrap(self->handle, wrap);
    Py_RETURN_NONE;
}

static PyObject* Style_rotation(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_rotation(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_rotation(StyleObject* self, PyObject* args)
{
    int rotation;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &rotation))
    {
        return NULL;
    }

    style_set_rotation(self->handle, rotation);
    Py_RETURN_NONE;
}

static PyObject* Style_indent(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_indent(self->handle);
    return PyLong_FromLong(result);
}

static PyObject* Style_set_indent(StyleObject* self, PyObject* args)
{
    int indent;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "i", &indent))
    {
        return NULL;
    }

    style_set_indent(self->handle, indent);
    Py_RETURN_NONE;
}

static PyObject* Style_shrink_to_fit(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_shrink_to_fit(self->handle);
    return PyBool_FromLong(result);
}

static PyObject* Style_set_shrink_to_fit(StyleObject* self, PyObject* args)
{
    int shrinkToFit;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "p", &shrinkToFit))
    {
        return NULL;
    }

    style_set_shrink_to_fit(self->handle, shrinkToFit);
    Py_RETURN_NONE;
}

static PyObject* Style_cell_locked(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_cell_locked(self->handle);
    return PyBool_FromLong(result);
}

static PyObject* Style_set_cell_locked(StyleObject* self, PyObject* args)
{
    int locked;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "p", &locked))
    {
        return NULL;
    }

    style_set_cell_locked(self->handle, locked);
    Py_RETURN_NONE;
}

static PyObject* Style_cell_hidden(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    int result = style_cell_hidden(self->handle);
    return PyBool_FromLong(result);
}

static PyObject* Style_set_cell_hidden(StyleObject* self, PyObject* args)
{
    int hidden;

    if (!check_handle(self->handle, "style"))
        return NULL;

    if (!PyArg_ParseTuple(args, "p", &hidden))
    {
        return NULL;
    }

    style_set_cell_hidden(self->handle, hidden);
    Py_RETURN_NONE;
}

static PyObject* Style_unapply_numfmt(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    style_unapply_numfmt(self->handle);
    Py_RETURN_NONE;
}

static PyObject* Style_unapply_font(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    style_unapply_font(self->handle);
    Py_RETURN_NONE;
}

static PyObject* Style_unapply_border(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    style_unapply_border(self->handle);
    Py_RETURN_NONE;
}

static PyObject* Style_unapply_fill(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    style_unapply_fill(self->handle);
    Py_RETURN_NONE;
}

static PyObject* Style_unapply_alignment(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    style_unapply_alignment(self->handle);
    Py_RETURN_NONE;
}

static PyObject* Style_unapply_protection(StyleObject* self, PyObject* args)
{
    if (!check_handle(self->handle, "style"))
        return NULL;

    style_unapply_protection(self->handle);
    Py_RETURN_NONE;
}

static PyMethodDef Style_methods[] = {
    {"set_numfmt", (PyCFunction)Style_set_numfmt, METH_VARARGS, "Set number format code"},
    {"numfmt_code", (PyCFunction)Style_numfmt_code, METH_NOARGS, "Get number format code"},
    {"numfmt_id", (PyCFunction)Style_numfmt_id, METH_NOARGS, "Get number format ID"},
    {"set_numfmt_id", (PyCFunction)Style_set_numfmt_id, METH_VARARGS, "Set number format ID"},

    {"set_font", (PyCFunction)Style_set_font, METH_VARARGS, "Set font name and size"},
    {"font_name", (PyCFunction)Style_font_name, METH_NOARGS, "Get font name"},
    {"font_size", (PyCFunction)Style_font_size, METH_NOARGS, "Get font size"},
    {"set_font_size", (PyCFunction)Style_set_font_size, METH_VARARGS, "Set font size"},
    {"italic", (PyCFunction)Style_italic, METH_NOARGS, "Check if italic"},
    {"set_italic", (PyCFunction)Style_set_italic, METH_VARARGS, "Set italic"},
    {"strikeout", (PyCFunction)Style_strikeout, METH_NOARGS, "Check if strikeout"},
    {"set_strikeout", (PyCFunction)Style_set_strikeout, METH_VARARGS, "Set strikeout"},
    {"font_color", (PyCFunction)Style_font_color, METH_NOARGS, "Get font color"},
    {"set_font_color", (PyCFunction)Style_set_font_color, METH_VARARGS, "Set font color"},
    {"bold", (PyCFunction)Style_bold, METH_NOARGS, "Check if bold"},
    {"set_bold", (PyCFunction)Style_set_bold, METH_VARARGS, "Set bold"},
    {"font_vert_align", (PyCFunction)Style_font_vert_align, METH_NOARGS, "Get font vertical alignment"},
    {"set_font_vert_align", (PyCFunction)Style_set_font_vert_align, METH_VARARGS, "Set font vertical alignment"},
    {"underlined", (PyCFunction)Style_underlined, METH_NOARGS, "Get underline style"},
    {"set_underline", (PyCFunction)Style_set_underline, METH_VARARGS, "Set underline style"},

    {"border", (PyCFunction)Style_border, METH_VARARGS, "Get border style"},
    {"set_border", (PyCFunction)Style_set_border, METH_VARARGS, "Set border style"},
    {"border_color", (PyCFunction)Style_border_color, METH_VARARGS, "Get border color"},
    {"set_border_color", (PyCFunction)Style_set_border_color, METH_VARARGS, "Set border color"},

    {"fill_pattern", (PyCFunction)Style_fill_pattern, METH_NOARGS, "Get fill pattern"},
    {"set_fill_pattern", (PyCFunction)Style_set_fill_pattern, METH_VARARGS, "Set fill pattern"},
    {"pattern_fg_color", (PyCFunction)Style_pattern_fg_color, METH_NOARGS, "Get pattern foreground color"},
    {"set_pattern_fg_color", (PyCFunction)Style_set_pattern_fg_color, METH_VARARGS, "Set pattern foreground color"},
    {"pattern_bg_color", (PyCFunction)Style_pattern_bg_color, METH_NOARGS, "Get pattern background color"},
    {"set_pattern_bg_color", (PyCFunction)Style_set_pattern_bg_color, METH_VARARGS, "Set pattern background color"},

    {"align_h", (PyCFunction)Style_align_h, METH_NOARGS, "Get horizontal alignment"},
    {"set_align_h", (PyCFunction)Style_set_align_h, METH_VARARGS, "Set horizontal alignment"},
    {"align_v", (PyCFunction)Style_align_v, METH_NOARGS, "Get vertical alignment"},
    {"set_align_v", (PyCFunction)Style_set_align_v, METH_VARARGS, "Set vertical alignment"},
    {"wrap", (PyCFunction)Style_wrap, METH_NOARGS, "Check if text wrapping is enabled"},
    {"set_wrap", (PyCFunction)Style_set_wrap, METH_VARARGS, "Set text wrapping"},
    {"rotation", (PyCFunction)Style_rotation, METH_NOARGS, "Get text rotation"},
    {"set_rotation", (PyCFunction)Style_set_rotation, METH_VARARGS, "Set text rotation"},
    {"indent", (PyCFunction)Style_indent, METH_NOARGS, "Get indent level"},
    {"set_indent", (PyCFunction)Style_set_indent, METH_VARARGS, "Set indent level"},
    {"shrink_to_fit", (PyCFunction)Style_shrink_to_fit, METH_NOARGS, "Check if shrink to fit is enabled"},
    {"set_shrink_to_fit", (PyCFunction)Style_set_shrink_to_fit, METH_VARARGS, "Set shrink to fit"},

    {"cell_locked", (PyCFunction)Style_cell_locked, METH_NOARGS, "Check if cell is locked"},
    {"set_cell_locked", (PyCFunction)Style_set_cell_locked, METH_VARARGS, "Set cell locked"},
    {"cell_hidden", (PyCFunction)Style_cell_hidden, METH_NOARGS, "Check if cell is hidden"},
    {"set_cell_hidden", (PyCFunction)Style_set_cell_hidden, METH_VARARGS, "Set cell hidden"},

    {"unapply_numfmt", (PyCFunction)Style_unapply_numfmt, METH_NOARGS, "Unapply number format"},
    {"unapply_font", (PyCFunction)Style_unapply_font, METH_NOARGS, "Unapply font settings"},
    {"unapply_border", (PyCFunction)Style_unapply_border, METH_NOARGS, "Unapply border settings"},
    {"unapply_fill", (PyCFunction)Style_unapply_fill, METH_NOARGS, "Unapply fill settings"},
    {"unapply_alignment", (PyCFunction)Style_unapply_alignment, METH_NOARGS, "Unapply alignment settings"},
    {"unapply_protection", (PyCFunction)Style_unapply_protection, METH_NOARGS, "Unapply protection settings"},

    {NULL} /* Sentinel */
};

PyTypeObject StyleType = {
    PyVarObject_HEAD_INIT(NULL, 0)
        .tp_name = "oosxl.Style",
    .tp_doc = "Style object",
    .tp_basicsize = sizeof(StyleObject),
    .tp_itemsize = 0,
    .tp_flags = Py_TPFLAGS_DEFAULT,
    .tp_new = PyType_GenericNew,
    .tp_dealloc = (destructor)Style_dealloc,
    .tp_methods = Style_methods,
};

PyObject* create_style_object(StyleHandle handle)
{
    StyleObject* obj = (StyleObject*)PyObject_New(StyleObject, &StyleType);
    if (obj != NULL)
    {
        obj->handle = handle;
    }
    return (PyObject*)obj;
}
