/**
 * style.h (C interface header file)
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef WORKBOOK_STYLE_INTERFACE_C_H
#define WORKBOOK_STYLE_INTERFACE_C_H

#include "port.h"
#include "handle.h"


#ifdef __cplusplus
extern "C" {
#endif

    DYLIB_PORT          int  DYLIB_CALL style_set_numfmt(StyleHandle style, const char* numFmtCode);
    DYLIB_PORT   const char* DYLIB_CALL style_numfmt_code(StyleHandle style);
    DYLIB_PORT          int  DYLIB_CALL style_numfmt_id(StyleHandle style);
    DYLIB_PORT          int  DYLIB_CALL style_set_numfmt_id(StyleHandle style, int numFmtId);

    DYLIB_PORT         void  DYLIB_CALL style_set_font(StyleHandle style, const char* name, int fontSize);
    DYLIB_PORT   const char* DYLIB_CALL style_font_name(StyleHandle style);
    DYLIB_PORT          int  DYLIB_CALL style_font_size(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_font_size(StyleHandle style, int size);
    DYLIB_PORT          int  DYLIB_CALL style_italic(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_italic(StyleHandle style, int italic);
    DYLIB_PORT          int  DYLIB_CALL style_strikeout(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_strikeout(StyleHandle style, int strikeOut);
    DYLIB_PORT     COLORREF  DYLIB_CALL style_font_color(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_font_color(StyleHandle style, COLORREF color);
    DYLIB_PORT          int  DYLIB_CALL style_bold(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_bold(StyleHandle style, int bold);
    DYLIB_PORT          int  DYLIB_CALL style_font_vert_align(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_font_vert_align(StyleHandle style, int v_alignRun);
    DYLIB_PORT          int  DYLIB_CALL style_underlined(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_underline(StyleHandle style, int underline);
                    
    DYLIB_PORT          int  DYLIB_CALL style_border(StyleHandle style, int index);
    DYLIB_PORT          int  DYLIB_CALL style_set_border(StyleHandle style, int index, int bs);
    DYLIB_PORT     COLORREF  DYLIB_CALL style_border_color(StyleHandle style, int index);
    DYLIB_PORT          int  DYLIB_CALL style_set_border_color(StyleHandle style, int index, COLORREF color);
                    
    DYLIB_PORT          int  DYLIB_CALL style_fill_pattern(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_fill_pattern(StyleHandle style, int pattern);
    DYLIB_PORT     COLORREF  DYLIB_CALL style_pattern_fg_color(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_pattern_fg_color(StyleHandle style, COLORREF color);
    DYLIB_PORT     COLORREF  DYLIB_CALL style_pattern_bg_color(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_pattern_bg_color(StyleHandle style, COLORREF color);

    DYLIB_PORT          int  DYLIB_CALL style_align_h(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_align_h(StyleHandle style, int h_alignment);
    DYLIB_PORT          int  DYLIB_CALL style_align_v(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_align_v(StyleHandle style, int v_alignment);
    DYLIB_PORT          int  DYLIB_CALL style_wrap(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_wrap(StyleHandle style, int wrap);
    DYLIB_PORT          int  DYLIB_CALL style_rotation(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_rotation(StyleHandle style, int rotation);
    DYLIB_PORT          int  DYLIB_CALL style_indent(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_indent(StyleHandle style, int indent);
    DYLIB_PORT          int  DYLIB_CALL style_shrink_to_fit(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_shrink_to_fit(StyleHandle style, int shrinkToFit);

    DYLIB_PORT          int  DYLIB_CALL style_cell_locked(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_cell_locked(StyleHandle style, int locked);
    DYLIB_PORT          int  DYLIB_CALL style_cell_hidden(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_set_cell_hidden(StyleHandle style, int hidden);

    DYLIB_PORT         void  DYLIB_CALL style_unapply_numfmt(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_unapply_font(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_unapply_border(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_unapply_fill(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_unapply_alignment(StyleHandle style);
    DYLIB_PORT         void  DYLIB_CALL style_unapply_protection(StyleHandle style);

    DYLIB_PORT         void  DYLIB_CALL style_release(StyleHandle style);

#ifdef __cplusplus
};
#endif

#endif // WORKBOOK_STYLE_INTERFACE_C_H

