/*
 * workbook.h (C interface header file)
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef WORKBOOK_INTERFACE_C_H
#define WORKBOOK_INTERFACE_C_H

#include "port.h"
#include "handle.h"


#ifdef __cplusplus
extern "C" {
#endif
    DYLIB_PORT             int  DYLIB_CALL wb_is_date1904(WorkbookHandle book);
    DYLIB_PORT            void  DYLIB_CALL wb_set_date1904(WorkbookHandle book, int set);
    DYLIB_PORT             int  DYLIB_CALL wb_is_a1_ref_mode(WorkbookHandle book);
    DYLIB_PORT            void  DYLIB_CALL wb_set_a1_ref_mode(WorkbookHandle book, int mode);
    DYLIB_PORT             int  DYLIB_CALL wb_get_calc_mode(WorkbookHandle book);
    DYLIB_PORT            void  DYLIB_CALL wb_set_calc_mode(WorkbookHandle book, int type);

    DYLIB_PORT WorksheetHandle  DYLIB_CALL wb_add_worksheet(WorkbookHandle book, const char* name);
    DYLIB_PORT WorksheetHandle  DYLIB_CALL wb_insert_worksheet(WorkbookHandle book, int index, const char* name);
    DYLIB_PORT            void  DYLIB_CALL wb_shift_sheet(WorkbookHandle book, int srcIndex, int dstIndex);
    DYLIB_PORT            void  DYLIB_CALL wb_delete_sheet(WorkbookHandle book, int index);

    DYLIB_PORT             int  DYLIB_CALL wb_sheet_count(WorkbookHandle book);
    DYLIB_PORT WorksheetHandle  DYLIB_CALL wb_get_sheet(WorkbookHandle book, int index);
    DYLIB_PORT             int  DYLIB_CALL wb_sheet_type(WorkbookHandle book, int index);
    DYLIB_PORT             int  DYLIB_CALL wb_get_sheet_state(WorkbookHandle book, int index);
    DYLIB_PORT            void  DYLIB_CALL wb_set_sheet_state(WorkbookHandle book, int index, int state);

    DYLIB_PORT      const char* DYLIB_CALL wb_sheet_name(WorkbookHandle book, int index);
    DYLIB_PORT            void  DYLIB_CALL wb_rename_sheet(WorkbookHandle book, int index, const char* newname);

    DYLIB_PORT             int  DYLIB_CALL wb_get_active_sheet(WorkbookHandle book);
    DYLIB_PORT             int  DYLIB_CALL wb_set_active_sheet(WorkbookHandle book, int tab);
    
    DYLIB_PORT             int  DYLIB_CALL wb_set_defined_name(WorkbookHandle book, const char* name, const char* expr, const char* local_name);
    DYLIB_PORT             int  DYLIB_CALL wb_defined_name_num(WorkbookHandle book);
    DYLIB_PORT      const char* DYLIB_CALL wb_get_defined_name(WorkbookHandle book, int index, int* is_local);
    DYLIB_PORT      const char* DYLIB_CALL wb_get_local_name(WorkbookHandle book, int index);
    DYLIB_PORT      const char* DYLIB_CALL wb_get_defined_name_expr(WorkbookHandle book, int index);
    DYLIB_PORT            void  DYLIB_CALL wb_delete_defined_name(WorkbookHandle book, int index);
    
    DYLIB_PORT     StyleHandle  DYLIB_CALL wb_get_named_style(WorkbookHandle book, const char* name);
    DYLIB_PORT     StyleHandle  DYLIB_CALL wb_add_custom_style(WorkbookHandle book, const char* name, StyleHandle style);
    DYLIB_PORT             int  DYLIB_CALL wb_modify_named_style(WorkbookHandle book, const char* name, StyleHandle style);

    DYLIB_PORT     StyleHandle  DYLIB_CALL wb_make_normal_style(WorkbookHandle book);
    DYLIB_PORT  RichtextHandle  DYLIB_CALL wb_make_richtext(WorkbookHandle book);
    
#ifdef __cplusplus
};
#endif

#endif // WORKBOOK_INTERFACE_C_H

