/**
 * document.hxx
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef DOCUMENT_CPP_INTERFACE_H
#define DOCUMENT_CPP_INTERFACE_H

#include "port.h"
#include "enum.h"


namespace oo {

struct iWorkbook;

struct iDocument
{
    virtual      void  set_key(const char* user_name, const char* key) = 0;
    virtual iWorkbook* get_workbook() = 0;
    virtual      bool  save(const char* filename = 0) = 0;

    virtual      void  release() = 0;

protected:
    virtual ~iDocument() { }
};

}


#ifdef __cplusplus
extern "C" {
#endif

DYLIB_PORT oo::iDocument* DYLIB_CALL create_document();
DYLIB_PORT oo::iDocument* DYLIB_CALL load_document(const char* filename);

DYLIB_PORT const char*    DYLIB_CALL lib_version();

#ifdef __cplusplus
}
#endif

#endif // DOCUMENT_CPP_INTERFACE_H

