/**
 * rich_text.hxx
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef RICHTEXT_INTERFACE_H
#define RICHTEXT_INTERFACE_H

#include "port.h"
#include "enum.h"


namespace oo {

struct iStyle;

struct iRichtext
{
    virtual        int  segments_num() const = 0;
    virtual const char* plain_text() const = 0;
    virtual const char* text(int index, iStyle** style = 0) const = 0;
    virtual       void  append(const char* s, iStyle* style = 0) = 0;
    virtual       void  insert(int index, const char* s, iStyle* style = 0) = 0;
    virtual       void  remove(int index) = 0;
    virtual       void  modify(int index, const char* s, iStyle* style = 0) = 0;

    virtual       void  release() = 0;

protected:
    virtual ~iRichtext() {}
};

}

#endif // RICHTEXT_INTERFACE_H

