/**
 * style.hxx
 *
 *      Copyright (c) 2025 CHBXUE. All rights reserved.
 *
 * THIS FILE AND THE SOFTWARE CONTAINED HEREIN IS PROVIDED 'AS IS' AND
 * COMES WITH NO WARRANTIES OF ANY KIND.
 */

#ifndef STYLE_INTERFACE_H
#define STYLE_INTERFACE_H

#include "port.h"
#include "enum.h"


namespace oo {

struct iStyle
{
    virtual              int  set_numfmt_code(const char* numFmtCode) = 0;
    virtual       const char* numfmt_code() const = 0;
    virtual              int  numfmt_id() const = 0;
    virtual             bool  set_numfmt_id(int numFmtId) = 0;

    virtual             void  set_font(const char* name, int fontSize = 0) = 0;
    virtual       const char* font_name() const = 0;
    virtual              int  font_size() const = 0;
    virtual             void  set_font_size(int size) = 0;
    virtual             bool  italic() const = 0;
    virtual             void  set_italic(bool italic = true) = 0;
    virtual             bool  strikeout() const = 0;
    virtual             void  set_strikeout(bool strikeOut = true) = 0;
    virtual        COLORREF   font_color() const = 0;
    virtual             void  set_font_color(COLORREF color) = 0;
    virtual             bool  bold() const = 0;
    virtual             void  set_bold(bool bold = true) = 0;
    virtual VertAlignRunEnum  font_vert_align() const = 0;
    virtual             void  set_font_vert_align(VertAlignRunEnum v_alignRun) = 0;
    virtual    UnderlineEnum  underlined() const = 0;
    virtual             void  set_underline(UnderlineEnum underline) = 0;
    
    virtual  BorderStyleEnum  border(BorderIndexEnum index) const = 0;
    virtual             bool  set_border(BorderIndexEnum index, BorderStyleEnum style) = 0;
    virtual         COLORREF  border_color(BorderIndexEnum index) const = 0;
    virtual             bool  set_border_color(BorderIndexEnum index, COLORREF color) = 0;

    virtual  PatternTypeEnum  fill_pattern() const = 0;
    virtual             void  set_fill_pattern(PatternTypeEnum pattern) = 0;
    virtual         COLORREF  pattern_fg_color() const = 0;
    virtual             void  set_pattern_fg_color(COLORREF color) = 0;
    virtual         COLORREF  pattern_bg_color() const = 0;
    virtual             void  set_pattern_bg_color(COLORREF color) = 0;
                             
    virtual       HAlignEnum  align_h() const = 0;
    virtual             void  set_align_h(HAlignEnum h_alignment) = 0;
    virtual       VAlignEnum  align_v() const = 0;
    virtual             void  set_align_v(VAlignEnum v_alignment) = 0;
    virtual             bool  wrap() const = 0;
    virtual             void  set_wrap(bool wrap = true) = 0;
    virtual              int  rotation() const = 0;
    virtual             void  set_rotation(int rotation) = 0;
    virtual              int  indent() const = 0;
    virtual             void  set_indent(int indent) = 0;
    virtual             bool  shrink_to_fit() const = 0;
    virtual             void  set_shrink_to_fit(bool shrinkToFit = true) = 0;
        
    virtual             bool  locked() const = 0;
    virtual             void  set_locked(bool locked = true) = 0;
    virtual             bool  hidden() const = 0;
    virtual             void  set_hidden(bool hidden = true) = 0;

    virtual             void  unapply_numfmt() = 0;
    virtual             void  unapply_font() = 0;
    virtual             void  unapply_fill() = 0;
    virtual             void  unapply_border() = 0;
    virtual             void  unapply_alignment() = 0;
    virtual             void  unapply_protection() = 0;
    virtual             void  unapply_all() = 0;

    virtual             void  release() = 0;

protected:
    virtual ~iStyle() {}
};

}

#endif // STYLE_INTERFACE_H

